/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresetHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private PresetHandler() {
    }

    public static boolean importPreset(ServerLevel serverLevel, CompoundTag compoundTag, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (position != null) {
            ListTag posTag = new ListTag();
            posTag.add((Object)DoubleTag.valueOf((double)position.x));
            posTag.add((Object)DoubleTag.valueOf((double)position.y));
            posTag.add((Object)DoubleTag.valueOf((double)position.z));
            compoundTag.put("Pos", (Tag)posTag);
        }
        if (uuid != null) {
            compoundTag.putUUID("UUID", uuid);
        }
        if (!PresetHandler.importPreset(serverLevel, compoundTag)) {
            return false;
        }
        UUID compoundUUID = compoundTag.getUUID("UUID");
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(compoundUUID, serverLevel);
        if (easyNPC == null) {
            log.error("[{}] Error importing preset {}, no entity found for {}", (Object)serverLevel, (Object)compoundTag, (Object)compoundUUID);
            return false;
        }
        OwnerDataCapable ownerData = easyNPC.getEasyNPCOwnerData();
        if (serverPlayer != null && ownerData != null) {
            ownerData.setNPCOwner((LivingEntity)serverPlayer);
        }
        if (position != null) {
            NavigationDataCapable navigationData = easyNPC.getEasyNPCNavigationData();
            if (navigationData == null) {
                log.warn("[{}] Warning: Importing preset, no navigation data available for {}", (Object)serverLevel, easyNPC);
            } else if (!easyNPC.getEntity().position().equals((Object)position)) {
                navigationData.setHomePosition(new BlockPos((int)position.x, (int)position.y, (int)position.z));
            }
        }
        log.debug("[{}] Imported preset data {} for {}", (Object)serverLevel, (Object)compoundUUID, easyNPC);
        return true;
    }

    public static boolean importPreset(ServerLevel serverLevel, CompoundTag compoundTag) {
        Entity entity;
        UUID existingUUID;
        EntityType entityType;
        if (serverLevel == null || compoundTag == null) {
            log.error("[{}] Error importing preset ", (Object)serverLevel);
            return false;
        }
        if (compoundTag.isEmpty()) {
            log.error("[{}] Empty preset data for import", (Object)serverLevel);
            return false;
        }
        EntityType entityType2 = entityType = compoundTag.contains("id") ? (EntityType)EntityType.byString((String)compoundTag.getString("id")).orElse(null) : null;
        if (entityType == null) {
            log.error("[{}] Error importing preset, invalid entity type", (Object)serverLevel);
            return false;
        }
        UUID uUID = existingUUID = compoundTag.contains("UUID") ? compoundTag.getUUID("UUID") : null;
        if (existingUUID != null && LivingEntityManager.getEasyNPCEntityByUUID(existingUUID, serverLevel) != null) {
            EasyNPC<?> existingEasyNPC = LivingEntityManager.getEasyNPCEntityByUUID(existingUUID, serverLevel);
            if (compoundTag.contains("id") && !compoundTag.getString("id").isEmpty() && compoundTag.getString("id").equals(existingEasyNPC.getEntityTypeId()) && existingEasyNPC.getEasyNPCPresetData() != null) {
                log.debug("[{}] Update preset data for existing entity {}!", (Object)serverLevel, existingEasyNPC);
                existingEasyNPC.getEasyNPCPresetData().importPresetData(compoundTag);
                return true;
            }
            LivingEntityManager.discardEasyNPCEntityByUUID(existingUUID, serverLevel);
        }
        if (!((entity = entityType.create((Level)serverLevel)) instanceof EasyNPC)) {
            log.error("[{}] Error importing preset, invalid entity with type {}", (Object)serverLevel, (Object)entityType);
            return false;
        }
        EasyNPC easyNPCEntity = (EasyNPC)entity;
        PresetDataCapable presetData = easyNPCEntity.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("[{}] Error importing preset, no preset data available for {}", (Object)serverLevel, (Object)easyNPCEntity);
            return false;
        }
        presetData.importPresetData(compoundTag);
        if (!serverLevel.addFreshEntity(easyNPCEntity.getEntity())) {
            log.error("[{}] Error spawning entity", (Object)easyNPCEntity);
            return false;
        }
        log.debug("[{}] Imported preset data {} for {}", (Object)serverLevel, (Object)compoundTag, (Object)easyNPCEntity);
        return true;
    }

    public static boolean importCustomPreset(ServerLevel serverLevel, ResourceLocation presetLocation, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing custom preset ", (Object)serverLevel);
            return false;
        }
        Path presetFile = CustomPresetDataFiles.getPresetsResourceLocationPath(presetLocation);
        if (presetFile == null || !presetFile.toFile().exists()) {
            log.error("[{}] Error importing custom preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            CompoundTag compoundTag = NbtIo.readCompressed((Path)presetFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading custom preset file {}", (Object)serverLevel, (Object)presetFile, (Object)exception);
            return false;
        }
    }

    public static boolean exportCustomPreset(EasyNPC<?> easyNPC, String name) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("[{}] Error no skin data available!", easyNPC);
            return false;
        }
        File presetFile = CustomPresetDataFiles.getPresetFile(skinData.getSkinModel(), name);
        return PresetHandler.exportPreset(easyNPC, presetFile);
    }

    public static boolean importDataPreset(ServerLevel serverLevel, ResourceLocation presetLocation, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing data preset ", (Object)serverLevel);
            return false;
        }
        MinecraftServer minecraftServer = serverLevel.getServer();
        if (minecraftServer.getResourceManager().getResource(presetLocation).isEmpty()) {
            log.error("[{}] Error importing data preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            CompoundTag compoundTag = NbtIo.readCompressed((InputStream)minecraftServer.getResourceManager().open(presetLocation), (NbtAccounter)NbtAccounter.unlimitedHeap());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading data preset file {}", (Object)serverLevel, (Object)presetLocation, (Object)exception);
            return false;
        }
    }

    public static boolean importDefaultPreset(ServerLevel serverLevel, ResourceLocation presetLocation, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing default preset ", (Object)serverLevel);
            return false;
        }
        MinecraftServer minecraftServer = serverLevel.getServer();
        if (minecraftServer.getResourceManager().getResource(presetLocation).isEmpty()) {
            log.error("[{}] Error importing data preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            CompoundTag compoundTag = NbtIo.readCompressed((InputStream)minecraftServer.getResourceManager().open(presetLocation), (NbtAccounter)NbtAccounter.unlimitedHeap());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading default preset file {}", (Object)serverLevel, (Object)presetLocation, (Object)exception);
            return false;
        }
    }

    public static boolean importLocalPreset(ServerLevel serverLevel, CompoundTag compoundTag, ResourceLocation presetLocation, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing local preset {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        if (compoundTag == null || compoundTag.isEmpty()) {
            log.error("[{}] Error importing local preset {}, no preset data found!", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        if (PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer)) {
            return true;
        }
        log.error("[{}] Error reading data preset file {}", (Object)serverLevel, (Object)presetLocation);
        return false;
    }

    public static boolean importWorldPreset(ServerLevel serverLevel, ResourceLocation presetLocation, Vec3 position, UUID uuid, ServerPlayer serverPlayer) {
        if (serverLevel == null || presetLocation == null) {
            log.error("[{}] Error importing world preset ", (Object)serverLevel);
            return false;
        }
        Path presetFile = WorldPresetDataFiles.getPresetsResourceLocationPath(presetLocation);
        if (presetFile == null || !presetFile.toFile().exists()) {
            log.error("[{}] Error importing world preset, no preset file found at {}", (Object)serverLevel, (Object)presetLocation);
            return false;
        }
        try {
            CompoundTag compoundTag = NbtIo.readCompressed((Path)presetFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
            return PresetHandler.importPreset(serverLevel, compoundTag, position, uuid, serverPlayer);
        }
        catch (IOException exception) {
            log.error("[{}] Error reading world preset file {}", (Object)serverLevel, (Object)presetFile, (Object)exception);
            return false;
        }
    }

    public static boolean exportWorldPreset(EasyNPC<?> easyNPC, String name) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("[{}] Error no skin data available!", easyNPC);
            return false;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile(skinData.getSkinModel(), name);
        return PresetHandler.exportPreset(easyNPC, presetFile);
    }

    public static boolean exportPreset(EasyNPC<?> easyNPC, File file) {
        if (easyNPC == null || file == null) {
            log.error("[{}] Error exporting preset {} !", easyNPC, (Object)file);
            return false;
        }
        PresetDataCapable presetData = easyNPC.getEasyNPCPresetData();
        if (presetData == null) {
            log.error("[{}] Error no preset data available!", easyNPC);
            return false;
        }
        CompoundTag compoundTag = presetData.serializePresetData();
        if (compoundTag == null || compoundTag.isEmpty()) {
            log.error("[{}] Error exporting custom preset {}!", easyNPC, (Object)file);
            return false;
        }
        return PresetHandler.exportPreset(file, compoundTag);
    }

    public static boolean exportPreset(File file, CompoundTag compoundTag) {
        if (file == null || compoundTag == null) {
            log.error("Error exporting preset file {} with {} !", (Object)file, (Object)compoundTag);
            return false;
        }
        if (compoundTag.isEmpty()) {
            log.error("Empty preset data for export to {} !", (Object)file);
            return false;
        }
        try {
            NbtIo.writeCompressed((CompoundTag)compoundTag, (Path)file.toPath());
            return true;
        }
        catch (IOException exception) {
            log.error("Failed to export preset file {} with {}:", (Object)file, (Object)compoundTag, (Object)exception);
            return false;
        }
    }
}

