/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.block;

import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCSpawnerBlock
extends SpawnerBlock {
    public static final EnumProperty<SpawnerType> SPAWNER_TYPE = EnumProperty.m_61587_((String)"spawner_type", SpawnerType.class);
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public EasyNPCSpawnerBlock(BlockBehaviour.Properties properties, SpawnerType spawnerType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SPAWNER_TYPE, (Comparable)((Object)spawnerType)));
    }

    public static SpawnerType getSpawnerType(BlockState blockState) {
        return (SpawnerType)((Object)blockState.m_61143_(SPAWNER_TYPE));
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EasyNPCSpawnerBlockEntity(null, blockPos, blockState, EasyNPCSpawnerBlock.getSpawnerType(blockState));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{SPAWNER_TYPE});
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity blockEntityInstance = (EasyNPCSpawnerBlockEntity)blockEntity;
            if (livingEntity != null) {
                blockEntityInstance.setSpawnerUUID(UUID.randomUUID());
                blockEntityInstance.setOwner(livingEntity);
                log.debug("Registered new NPC spawner with UUID {} for owner {} at {}", (Object)blockEntityInstance.getSpawnerUUID(), (Object)blockEntityInstance.getOwner(), (Object)blockPos);
            }
        }
    }
}

