/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.HorseRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.HorseMarkingLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.Horse;

public class HorseRawRenderer
extends AbstractHorseRenderer<Horse, HorseModel<Horse>>
implements EasyNPCEntityRenderer {
    protected static final Map<HorseRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.m_137469_(new EnumMap(HorseRaw.VariantType.class), map -> {
        map.put(HorseRaw.VariantType.WHITE, new ResourceLocation("minecraft", "textures/entity/horse/horse_white.png"));
        map.put(HorseRaw.VariantType.WHITE_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_white.png"));
        map.put(HorseRaw.VariantType.CREAMY, new ResourceLocation("minecraft", "textures/entity/horse/horse_creamy.png"));
        map.put(HorseRaw.VariantType.CREAMY_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_creamy.png"));
        map.put(HorseRaw.VariantType.CHESTNUT, new ResourceLocation("minecraft", "textures/entity/horse/horse_chestnut.png"));
        map.put(HorseRaw.VariantType.CHESTNUT_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_chestnut.png"));
        map.put(HorseRaw.VariantType.BROWN, new ResourceLocation("minecraft", "textures/entity/horse/horse_brown.png"));
        map.put(HorseRaw.VariantType.BROWN_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_brown.png"));
        map.put(HorseRaw.VariantType.BLACK, new ResourceLocation("minecraft", "textures/entity/horse/horse_black.png"));
        map.put(HorseRaw.VariantType.BLACK_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_black.png"));
        map.put(HorseRaw.VariantType.GRAY, new ResourceLocation("minecraft", "textures/entity/horse/horse_gray.png"));
        map.put(HorseRaw.VariantType.GRAY_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_gray.png"));
        map.put(HorseRaw.VariantType.DARKBROWN, new ResourceLocation("minecraft", "textures/entity/horse/horse_darkbrown.png"));
        map.put(HorseRaw.VariantType.DARKBROWN_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_darkbrown.png"));
        map.put(HorseRaw.VariantType.ZOMBIE, new ResourceLocation("minecraft", "textures/entity/horse/horse_zombie.png"));
        map.put(HorseRaw.VariantType.ZOMBIE_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_zombie.png"));
        map.put(HorseRaw.VariantType.SKELETON, new ResourceLocation("minecraft", "textures/entity/horse/horse_skeleton.png"));
        map.put(HorseRaw.VariantType.SKELETON_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/horse_skeleton.png"));
        map.put(HorseRaw.VariantType.DONKEY, new ResourceLocation("minecraft", "textures/entity/horse/donkey.png"));
        map.put(HorseRaw.VariantType.DONKEY_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/donkey.png"));
        map.put(HorseRaw.VariantType.MULE, new ResourceLocation("minecraft", "textures/entity/horse/mule.png"));
        map.put(HorseRaw.VariantType.MULE_SADDLED, new ResourceLocation("minecraft", "textures/entity/horse/mule.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)HorseRaw.VariantType.WHITE);

    public HorseRawRenderer(EntityRendererProvider.Context context) {
        super(context, new HorseModel(context.m_174023_(ModelLayers.f_171186_)), 1.1f);
        this.m_115326_((RenderLayer)new HorseMarkingLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new HorseArmorLayer((RenderLayerParent)this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(Horse entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

