/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EquipmentHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private EquipmentHandler() {
    }

    public static void setHandSlotItem(EasyNPC<?> easyNPC, InteractionHand interactionHand, ItemStack itemStack) {
        EquipmentHandler.setEquipmentSlotItem(easyNPC, interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, itemStack);
    }

    public static void setArmorSlotItem(EasyNPC<?> easyNPC, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        EquipmentHandler.setEquipmentSlotItem(easyNPC, equipmentSlot, itemStack);
    }

    public static boolean setEquipmentSlotItem(EasyNPC<?> easyNPC, EquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (easyNPC == null || equipmentSlot == null || itemStack == null) {
            log.error("[{}] Error setting owner ", easyNPC);
            return false;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        log.debug("[{}] Setting equipment slot {} to {}", easyNPC, (Object)equipmentSlot, (Object)itemStack);
        switch (equipmentSlot) {
            case MAINHAND: {
                livingEntity.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                break;
            }
            case OFFHAND: {
                livingEntity.m_21008_(InteractionHand.OFF_HAND, itemStack);
                break;
            }
            case HEAD: 
            case CHEST: 
            case LEGS: 
            case FEET: {
                livingEntity.m_8061_(equipmentSlot, itemStack);
                break;
            }
            default: {
                log.error("[{}] Equipment slot {} is not supported!", easyNPC, (Object)equipmentSlot);
                return false;
            }
        }
        return true;
    }
}

