/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReloadHandler {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ReloadHandler() {
    }

    public static boolean reloadNPC(EasyNPC<?> easyNPC, ServerLevel serverLevel) {
        if (easyNPC == null || serverLevel == null) {
            log.error("Unable to reload NPC with invalid EasyNPC {} or ServerLevel {}!", easyNPC, (Object)serverLevel);
            return false;
        }
        PathfinderMob entity = easyNPC.getPathfinderMob();
        if (entity == null || !entity.m_6084_()) {
            log.warn("Unable to reload NPC {} because entity is null or not alive!", (Object)easyNPC.getEntityUUID());
            return false;
        }
        CompoundTag compoundTag = easyNPC.getEntity().m_20240_(new CompoundTag());
        log.debug("Reloading NPC {} at position {}", (Object)easyNPC.getEntityUUID(), (Object)entity.m_20182_());
        entity.m_20258_(compoundTag);
        entity.m_6210_();
        return true;
    }
}

