/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradingOfferHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private TradingOfferHandler() {
    }

    public static void setAdvancedTradingMaxUses(TradingDataCapable<?> tradingData, int tradingOfferIndex, int maxUses) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), 0, maxUses, merchantOffer.m_45379_(), merchantOffer.m_45378_(), merchantOffer.m_45375_()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingXp(TradingDataCapable<?> tradingData, int tradingOfferIndex, int xp) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), xp, merchantOffer.m_45378_(), merchantOffer.m_45375_()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingPriceMultiplier(TradingDataCapable<?> tradingData, int tradingOfferIndex, float priceMultiplier) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), merchantOffer.m_45379_(), priceMultiplier, merchantOffer.m_45375_()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingDemand(TradingDataCapable<?> tradingData, int tradingOfferIndex, int demand) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), merchantOffer.m_45379_(), merchantOffer.m_45378_(), demand));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void updateBasicTradingOffers(TradingDataCapable<?> tradingData) {
        if (tradingData.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        MerchantOffers newMerchantOffers = new MerchantOffers();
        for (MerchantOffer merchantOffer : merchantOffers) {
            if (!TradingOfferHandler.isValidTradingOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_())) continue;
            MerchantOffer newMerchantOffer = new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), tradingData.getTradingDataSet().getMaxUses(), tradingData.getTradingDataSet().getRewardedXP(), merchantOffer.m_45378_());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        tradingData.setTradingOffers(newMerchantOffers);
    }

    private static boolean isValidTradingOffer(ItemStack itemA, ItemStack itemB, ItemStack itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.m_41619_() || itemB != null && !itemB.m_41619_()) && !itemResult.m_41619_();
    }
}

