/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.level;

import de.markusbordihn.easynpc.data.spawner.SpawnerData;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawner
extends BaseSpawner {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final Random random = new Random();
    private final SpawnerType spawnerType;
    private boolean isEasyNPC = false;
    private double oSpin;
    private double spin;
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int maxSpawnDelay = 800;
    private int minSpawnDelay = 200;
    private int requiredPlayerRange = 16;
    private int spawnCount = 4;
    private int spawnDelay = 20;
    private int spawnRange = 4;
    private ResourceLocation entityResourceLocation;
    private SpawnData nextSpawnData;
    private UUID easyNPCPresetUUID;
    private UUID easyNPCUUID;

    public BaseEasyNPCSpawner(SpawnerType spawnerType) {
        this.spawnerType = spawnerType;
        CompoundTag spawnerData = this.m_186381_(new CompoundTag());
        SpawnerData.setSpawnData(spawnerType, spawnerData);
        this.updateSpawnData(spawnerData);
        this.m_151328_(null, null, spawnerData);
    }

    public void m_142523_(Level level, BlockPos blockPos, int eventId) {
        level.m_7696_(blockPos, Blocks.f_50085_, eventId, 0);
    }

    public void m_142667_(Level level, BlockPos blockPos, SpawnData spawnData) {
        super.m_142667_(level, blockPos, spawnData);
        if (level != null) {
            BlockState blockState = level.m_8055_(blockPos);
            level.m_7260_(blockPos, blockState, blockState, 4);
        }
        this.updateSpawnData(this.m_186381_(new CompoundTag()));
    }

    public void m_151319_(Level level, BlockPos blockPos) {
        EasyNPC<?> easyNPC;
        if (!this.hasEasyNPC()) {
            return;
        }
        if (!this.isNearPlayer(level, blockPos, this.requiredPlayerRange)) {
            this.oSpin = this.spin;
            return;
        }
        if (this.maxNearbyEntities == 1 && (easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(this.easyNPCUUID)) != null && easyNPC.getEntity().m_6084_()) {
            this.oSpin = this.spin;
            return;
        }
        if (this.easyNPCPresetUUID != null && LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID) >= this.maxNearbyEntities) {
            this.oSpin = this.spin;
            return;
        }
        double x = (double)blockPos.m_123341_() + level.f_46441_.m_188500_();
        double y = (double)blockPos.m_123342_() + level.f_46441_.m_188500_();
        double z = (double)blockPos.m_123343_() + level.f_46441_.m_188500_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
        this.oSpin = this.spin;
        this.spin = (this.spin + 1000.0 / ((double)this.spawnDelay + 200.0)) % 360.0;
    }

    public void m_151311_(ServerLevel serverLevel, BlockPos blockPos) {
        Entity entity;
        if (!this.hasEasyNPC()) {
            return;
        }
        if (this.requiredPlayerRange > 0 && !this.isNearPlayer((Level)serverLevel, blockPos, this.requiredPlayerRange)) {
            return;
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        this.m_151350_((Level)serverLevel, blockPos);
        if (this.maxNearbyEntities == 1 && this.easyNPCUUID != null && (entity = serverLevel.m_8791_(this.easyNPCUUID)) != null && entity.m_6084_()) {
            this.m_151350_((Level)serverLevel, blockPos);
            return;
        }
        if (this.easyNPCPresetUUID != null && LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID) >= this.maxNearbyEntities) {
            this.m_151350_((Level)serverLevel, blockPos);
            return;
        }
        this.spawnEasyNPC(serverLevel, blockPos);
    }

    public Entity m_253067_(Level level, RandomSource randomSource, BlockPos blockPos) {
        if (this.displayEntity == null) {
            this.displayEntity = EntityType.m_20645_((CompoundTag)this.nextSpawnData.m_186567_(), (Level)level, Function.identity());
        }
        return this.displayEntity;
    }

    public double m_45473_() {
        return this.spin;
    }

    public double m_45474_() {
        return this.oSpin;
    }

    private boolean isNearPlayer(Level level, BlockPos pos, int requiredPlayerRange) {
        return level.m_45914_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)requiredPlayerRange);
    }

    private void m_151350_(Level level, BlockPos pos) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.m_142523_(level, pos, 1);
    }

    private void spawnEasyNPC(ServerLevel level, BlockPos pos) {
        boolean spawned = false;
        for (int i = 0; i < this.spawnCount; ++i) {
            Mob mob;
            double finalZ;
            double finalY;
            double finalX;
            Entity entity;
            double z;
            ListTag posList;
            int posSize;
            CompoundTag entityTag = this.nextSpawnData.m_186567_();
            Optional entityType = EntityType.m_20637_((CompoundTag)entityTag);
            if (entityType.isEmpty()) {
                this.m_151350_((Level)level, pos);
                return;
            }
            if (this.maxNearbyEntities > 1 && entityTag.m_128441_("UUID")) {
                entityTag.m_128473_("UUID");
            }
            double x = (posSize = (posList = entityTag.m_128437_("Pos", 6)).size()) >= 1 ? posList.m_128772_(0) : (double)pos.m_123341_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)this.spawnRange + 0.5;
            double y = posSize >= 2 ? posList.m_128772_(1) : (double)(pos.m_123342_() + level.f_46441_.m_188503_(3) - 1);
            double d = z = posSize >= 3 ? posList.m_128772_(2) : (double)pos.m_123343_() + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * (double)this.spawnRange + 0.5;
            if (!level.m_45772_(((EntityType)entityType.get()).m_20585_(x, y, z))) {
                BlockPos possibleSpawnPositions;
                if (this.maxNearbyEntities <= 1 || (possibleSpawnPositions = (BlockPos)BlockPos.m_121930_((BlockPos)pos, (int)this.spawnRange, (int)this.spawnRange, possibleBlockPos -> level.m_45772_(((EntityType)entityType.get()).m_20585_((double)possibleBlockPos.m_123341_() + 0.5, (double)possibleBlockPos.m_123342_(), (double)possibleBlockPos.m_123343_() + 0.5)) && !level.m_8055_(possibleBlockPos.m_7495_()).m_60795_()).orElse(null)) == null) continue;
                x = (double)possibleSpawnPositions.m_123341_() + 0.5;
                y = possibleSpawnPositions.m_123342_();
                z = (double)possibleSpawnPositions.m_123343_() + 0.5;
            }
            if ((entity = EntityType.m_20645_((CompoundTag)entityTag, (Level)level, arg_0 -> BaseEasyNPCSpawner.lambda$spawnEasyNPC$1(finalX = x, finalY = y, finalZ = z, arg_0))) == null) {
                this.m_151350_((Level)level, pos);
                return;
            }
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), level.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                if (this.nextSpawnData.m_186574_().isEmpty() && !mob.m_5545_((LevelAccessor)level, MobSpawnType.SPAWNER) || !mob.m_6914_((LevelReader)level)) continue;
                mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, null, null);
            }
            if (!level.m_8860_(entity)) {
                this.m_151350_((Level)level, pos);
                return;
            }
            level.m_46796_(2004, pos, 0);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                mob.m_21373_();
            }
            spawned = true;
        }
        if (spawned) {
            this.m_151350_((Level)level, pos);
        }
    }

    public boolean hasEasyNPC() {
        return this.isEasyNPC;
    }

    public UUID getEasyNPCUUID() {
        return this.easyNPCUUID;
    }

    public UUID getEasyNPCPresetUUID() {
        return this.easyNPCPresetUUID;
    }

    public void m_151328_(Level level, BlockPos blockPos, CompoundTag compoundTag) {
        super.m_151328_(level, blockPos, compoundTag);
        this.updateSpawnData(compoundTag);
    }

    public void updateSpawnData(CompoundTag compoundTag) {
        CompoundTag spawnData;
        this.spawnDelay = SpawnerData.getDelay(compoundTag);
        this.minSpawnDelay = SpawnerData.getMinSpawnDelay(compoundTag);
        this.maxSpawnDelay = SpawnerData.getMaxSpawnDelay(compoundTag);
        this.spawnCount = SpawnerData.getSpawnCount(compoundTag);
        this.maxNearbyEntities = SpawnerData.getMaxNearbyEntities(compoundTag);
        this.requiredPlayerRange = SpawnerData.getRequiredPlayerRange(compoundTag);
        this.spawnRange = SpawnerData.getSpawnRange(compoundTag);
        this.nextSpawnData = SpawnerData.getSpawnData(compoundTag);
        this.isEasyNPC = false;
        this.easyNPCUUID = null;
        this.easyNPCPresetUUID = null;
        if (SpawnerData.hasSpawnData(compoundTag) && (spawnData = compoundTag.m_128469_("SpawnData")).m_128441_("entity")) {
            CompoundTag entityData = spawnData.m_128469_("entity");
            if (entityData.m_128441_("id")) {
                this.entityResourceLocation = ResourceLocation.m_135820_((String)entityData.m_128461_("id"));
                this.isEasyNPC = this.entityResourceLocation.m_135827_().equals("easy_npc");
            }
            if (entityData.m_128441_("UUID")) {
                this.easyNPCUUID = entityData.m_128342_("UUID");
            }
            if (entityData.m_128441_("PresetUUID")) {
                this.easyNPCPresetUUID = entityData.m_128342_("PresetUUID");
            }
        }
    }

    private static /* synthetic */ Entity lambda$spawnEasyNPC$1(double finalX, double finalY, double finalZ, Entity loadedEntity) {
        loadedEntity.m_7678_(finalX, finalY, finalZ, loadedEntity.m_146908_(), loadedEntity.m_146909_());
        return loadedEntity;
    }
}

