/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.trading;

import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SafeMerchantData<E extends PathfinderMob>
implements Merchant {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final boolean DEFAULT_CAN_RESTOCK = false;
    private static final boolean DEFAULT_SHOW_PROGRESS_BAR = true;
    private static final int DEFAULT_TRADE_DISTANCE_SQR = 64;
    private static final int DEFAULT_VILLAGER_LEVEL = 0;
    private static final int DEFAULT_VILLAGER_XP = 0;
    private final TradingDataCapable<E> tradingData;

    public SafeMerchantData(TradingDataCapable<E> tradingData) {
        this.tradingData = tradingData;
    }

    public Player getTradingPlayer() {
        return this.tradingData.getTradingPlayer();
    }

    public void setTradingPlayer(Player player) {
        this.tradingData.setTradingPlayer(player);
    }

    public MerchantOffers getOffers() {
        return this.tradingData.getOffers();
    }

    public void overrideOffers(MerchantOffers offers) {
        this.tradingData.overrideOffers(offers);
    }

    public void notifyTrade(MerchantOffer offer) {
        this.tradingData.notifyTrade(offer);
    }

    public void notifyTradeUpdated(ItemStack stack) {
        this.tradingData.notifyTradeUpdated(stack);
    }

    public int getVillagerXp() {
        try {
            return this.tradingData.getVillagerXp();
        }
        catch (AbstractMethodError e) {
            return 0;
        }
    }

    public void overrideXp(int xp) {
        try {
            this.tradingData.overrideXp(xp);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public boolean showProgressBar() {
        try {
            return this.tradingData.showProgressBar();
        }
        catch (AbstractMethodError e) {
            return true;
        }
    }

    public SoundEvent getNotifyTradeSound() {
        try {
            return this.tradingData.getNotifyTradeSound();
        }
        catch (AbstractMethodError e) {
            return SoundEvents.VILLAGER_TRADE;
        }
    }

    public boolean isClientSide() {
        return this.tradingData.isClientSideInstance();
    }

    public boolean stillValid(Player player) {
        Entity entity = this.tradingData.getEntity();
        return entity.isAlive() && player.distanceToSqr(entity) <= 64.0;
    }

    public void openTradingScreen(Player player, Component name, int containerId) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MerchantOffers offers = this.getOffers();
            if (offers == null || offers.isEmpty()) {
                log.error("No trading offers available for {} with name {}", (Object)serverPlayer.getName().getString(), (Object)name.getString());
                return;
            }
            log.debug("Opening trading screen for {} with {} offers", (Object)serverPlayer.getName().getString(), (Object)offers.size());
            serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new MerchantMenu(id, inventory, (Merchant)this), name));
            serverPlayer.sendMerchantOffers(serverPlayer.containerMenu.containerId, offers, this.getVillagerXp(), 0, this.showProgressBar(), false);
        }
    }
}

