/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc;

import de.markusbordihn.easynpc.data.trading.SafeMerchantData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;

public final class EasyNPCEntityAccess {
    public static <E extends PathfinderMob> LookControl getLookControl(EasyNPC<E> easyNPC) {
        LookControl lookControl;
        if (easyNPC instanceof Mob) {
            Mob mob = (Mob)easyNPC;
            lookControl = mob.getLookControl();
        } else {
            lookControl = null;
        }
        return lookControl;
    }

    public static <E extends PathfinderMob> PathfinderMob getPathfinderMob(EasyNPC<E> easyNPC) {
        PathfinderMob pathfinderMob;
        return easyNPC instanceof PathfinderMob ? (pathfinderMob = (PathfinderMob)easyNPC) : null;
    }

    public static <E extends PathfinderMob> Level getLevel(EasyNPC<E> easyNPC) {
        Level level;
        if (easyNPC instanceof Mob) {
            Mob mob = (Mob)easyNPC;
            level = mob.level();
        } else {
            level = null;
        }
        return level;
    }

    public static <E extends PathfinderMob> ServerLevel getServerLevel(EasyNPC<E> easyNPC) {
        ServerLevel serverLevel;
        Mob mob;
        Level level;
        return easyNPC instanceof Mob && (level = (mob = (Mob)easyNPC).level()) instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
    }

    public static <E extends PathfinderMob> boolean isClientSide(EasyNPC<E> easyNPC) {
        return easyNPC.getEntityLevel() != null && easyNPC.getEntityLevel().isClientSide();
    }

    public static <E extends PathfinderMob> boolean isServerSide(EasyNPC<E> easyNPC) {
        return !EasyNPCEntityAccess.isClientSide(easyNPC);
    }

    public static <E extends PathfinderMob> LivingEntity getLivingEntity(EasyNPC<E> easyNPC) {
        LivingEntity livingEntity;
        return easyNPC instanceof LivingEntity ? (livingEntity = (LivingEntity)easyNPC) : null;
    }

    public static <E extends PathfinderMob> Merchant getMerchant(EasyNPC<E> easyNPC) {
        return easyNPC instanceof Merchant ? new SafeMerchantData(easyNPC.getEasyNPCTradingData()) : null;
    }

    public static <E extends PathfinderMob> CrossbowAttackMob getCrossbowAttackMob(EasyNPC<E> easyNPC) {
        CrossbowAttackMob crossbowAttackMob;
        return easyNPC instanceof CrossbowAttackMob ? (crossbowAttackMob = (CrossbowAttackMob)easyNPC) : null;
    }

    public static <E extends PathfinderMob> RangedAttackMob getRangedAttackMob(EasyNPC<E> easyNPC) {
        RangedAttackMob rangedAttackMob;
        return easyNPC instanceof RangedAttackMob ? (rangedAttackMob = (RangedAttackMob)easyNPC) : null;
    }

    public static <E extends PathfinderMob> ProfilerFiller getProfiler(EasyNPC<E> easyNPC) {
        return easyNPC instanceof Mob ? Profiler.get() : null;
    }

    public static <E extends PathfinderMob> Entity getEntity(EasyNPC<E> easyNPC) {
        Entity entity;
        return easyNPC instanceof Entity ? (entity = (Entity)easyNPC) : null;
    }

    public static <E extends PathfinderMob> UUID getEntityUUID(EasyNPC<E> easyNPC) {
        UUID uUID;
        if (easyNPC instanceof Entity) {
            Entity entity = (Entity)easyNPC;
            uUID = entity.getUUID();
        } else {
            uUID = null;
        }
        return uUID;
    }

    public static <E extends PathfinderMob> Component getEntityTypeName(EasyNPC<E> easyNPC) {
        Component component;
        if (easyNPC instanceof Entity) {
            Entity entity = (Entity)easyNPC;
            component = entity.getType().getDescription();
        } else {
            component = null;
        }
        return component;
    }

    public static <E extends PathfinderMob> EntityType<?> getEntityType(EasyNPC<E> easyNPC) {
        EntityType entityType;
        if (easyNPC instanceof Entity) {
            Entity entity = (Entity)easyNPC;
            entityType = entity.getType();
        } else {
            entityType = null;
        }
        return entityType;
    }

    public static <E extends PathfinderMob> String getEntityTypeId(EasyNPC<E> easyNPC) {
        EntityType<?> entityType = EasyNPCEntityAccess.getEntityType(easyNPC);
        if (entityType == null || !entityType.canSerialize()) {
            return null;
        }
        return EntityType.getKey(entityType).toString();
    }

    public static <E extends PathfinderMob> Mob getMob(EasyNPC<E> easyNPC) {
        Mob mob;
        return easyNPC instanceof Mob ? (mob = (Mob)easyNPC) : null;
    }
}

