/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.EnumMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

public interface OwnerDataCapable<T extends PathfinderMob>
extends EasyNPC<T>,
OwnableEntity {
    public static final String DATA_OWNER_TAG = "Owner";

    public static void registerSyncedOwnerData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Owner Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.OWNER_UUID, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE));
    }

    default public void setNPCOwnerUUID(UUID uuid) {
        if (uuid == null) {
            this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.empty());
        } else {
            EntityReference entityReference = new EntityReference(uuid);
            this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.of(entityReference));
        }
    }

    default public UUID getOwnerUUID() {
        EntityReference<LivingEntity> ownerReference = this.getOwnerReference();
        return ownerReference == null ? null : ownerReference.getUUID();
    }

    default public EntityReference<LivingEntity> getOwnerReference() {
        Optional ownerReference = (Optional)this.getSynchedEntityData(SynchedDataIndex.OWNER_UUID);
        return ownerReference.orElse(null);
    }

    default public boolean hasNPCOwner() {
        return this.getOwnerUUID() != null;
    }

    default public boolean isNPCOwnedBy(LivingEntity livingEntity) {
        return livingEntity != null && this.hasNPCOwner() && livingEntity.getUUID().equals(this.getOwnerUUID());
    }

    default public void setNPCOwner(LivingEntity owner) {
        if (owner != null) {
            this.setNPCOwnerUUID(owner.getUUID());
        } else {
            this.setNPCOwnerUUID(null);
        }
    }

    default public String getNPCOwnerName() {
        LivingEntity owner = this.getOwner();
        return owner == null ? "" : owner.getName().getString();
    }

    default public boolean isNPCOwner(ServerPlayer serverPlayer) {
        return serverPlayer != null && this.isNPCOwner(serverPlayer.getUUID());
    }

    default public boolean isNPCOwner(UUID uuid) {
        return uuid != null && this.hasNPCOwner() && uuid.equals(this.getOwnerUUID());
    }

    default public LivingEntity getOwner() {
        Level level = this.getEntityLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : level.getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public void defineSynchedOwnerData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.OWNER_UUID, Optional.empty());
    }

    default public void addAdditionalOwnerData(CompoundTag compoundTag) {
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID != null) {
            CompoundTagUtils.writeUUID(compoundTag, DATA_OWNER_TAG, ownerUUID);
        }
    }

    default public void readAdditionalOwnerData(CompoundTag compoundTag) {
        UUID ownerUUID = CompoundTagUtils.readUUID(compoundTag, DATA_OWNER_TAG);
        if (ownerUUID != null) {
            this.setNPCOwnerUUID(ownerUUID);
        }
    }
}

