/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import de.markusbordihn.easynpc.client.renderer.entity.EntityRendererUtils;
import de.markusbordihn.easynpc.client.renderer.entity.ModCustomEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.ModEpicFightEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.ModNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.ModRawEntityRenderer;
import de.markusbordihn.easynpc.compat.CompatConstants;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.entity.UserDefinedEntityRegistry;
import de.markusbordihn.easynpc.entity.UserDefinedEntityType;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EntityRenderer {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private EntityRenderer() {
    }

    public static void register(EntityRenderersEvent.RegisterRenderers event) {
        log.info("{} Entity Renders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        for (ModRawEntityRenderer modRawEntityRenderer : ModRawEntityRenderer.values()) {
            event.registerEntityRenderer(ModEntityType.getEntityType(modRawEntityRenderer.getEntityType()), context -> modRawEntityRenderer.getRenderer().apply(context));
        }
        for (Enum enum_ : ModNPCEntityRenderer.values()) {
            event.registerEntityRenderer(ModEntityType.getEntityType(((ModNPCEntityRenderer)enum_).getEntityType()), arg_0 -> EntityRenderer.lambda$register$1((ModNPCEntityRenderer)enum_, arg_0));
        }
        for (Enum enum_ : ModCustomEntityRenderer.values()) {
            event.registerEntityRenderer(ModEntityType.getEntityType(((ModCustomEntityRenderer)enum_).getEntityType()), arg_0 -> EntityRenderer.lambda$register$2((ModCustomEntityRenderer)enum_, arg_0));
        }
        for (UserDefinedEntityType type : UserDefinedEntityRegistry.getAvailableEntityTypes()) {
            EntityType<?> entityType = UserDefinedEntityRegistry.getRegisteredEntityType(type);
            if (entityType == null) continue;
            EntityRenderer.registerEntityRendererWithProvider(event, entityType, context -> EntityRenderer.createRendererForBaseType(context, type.getBaseEntityType()));
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            for (ModEpicFightEntityRenderer modEpicFightEntityRenderer : ModEpicFightEntityRenderer.values()) {
                event.registerEntityRenderer(ModEntityType.getEntityType(modEpicFightEntityRenderer.getEntityType()), context -> modEpicFightEntityRenderer.getRenderer().apply(context));
            }
        }
    }

    private static <T extends Entity> void registerEntityRendererWithProvider(EntityRenderersEvent.RegisterRenderers event, EntityType<?> entityType, Function<EntityRendererProvider.Context, ?> rendererFactory) {
        EntityRendererProvider provider = context -> (net.minecraft.client.renderer.entity.EntityRenderer)rendererFactory.apply(context);
        event.registerEntityRenderer(entityType, provider);
    }

    private static net.minecraft.client.renderer.entity.EntityRenderer<?, ?> createRendererForBaseType(EntityRendererProvider.Context context, EntityType<?> baseEntityType) {
        for (ModRawEntityRenderer modRawEntityRenderer : ModRawEntityRenderer.values()) {
            if (ModEntityType.getEntityType(modRawEntityRenderer.getEntityType()) != baseEntityType) continue;
            return modRawEntityRenderer.getRenderer().apply(context);
        }
        for (Enum enum_ : ModNPCEntityRenderer.values()) {
            if (ModEntityType.getEntityType(((ModNPCEntityRenderer)enum_).getEntityType()) != baseEntityType) continue;
            return ((ModNPCEntityRenderer)enum_).getRenderer().apply(context);
        }
        for (Enum enum_ : ModCustomEntityRenderer.values()) {
            if (ModEntityType.getEntityType(((ModCustomEntityRenderer)enum_).getEntityType()) != baseEntityType) continue;
            return ((ModCustomEntityRenderer)enum_).getRenderer().apply(context);
        }
        Function<EntityRendererProvider.Context, net.minecraft.client.renderer.entity.EntityRenderer<?, ?>> rendererFactory = EntityRendererUtils.getVanillaRendererFactory(baseEntityType);
        if (rendererFactory != null) {
            return rendererFactory.apply(context);
        }
        return EntityRendererUtils.createFallbackRenderer(context, baseEntityType);
    }

    private static /* synthetic */ net.minecraft.client.renderer.entity.EntityRenderer lambda$register$2(ModCustomEntityRenderer renderer, EntityRendererProvider.Context context) {
        return renderer.getRenderer().apply(context);
    }

    private static /* synthetic */ net.minecraft.client.renderer.entity.EntityRenderer lambda$register$1(ModNPCEntityRenderer renderer, EntityRendererProvider.Context context) {
        return renderer.getRenderer().apply(context);
    }
}

