/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.DegreeNumberField;
import de.markusbordihn.easynpc.client.screen.components.PositionNumberField;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.ScaleNumberField;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class RangeSliderButton
extends AbstractWidget {
    public static final Component DECREASE_TEXT = TextComponent.getText("-");
    public static final Component INCREASE_TEXT = TextComponent.getText("+");
    public static final Component RESET_TEXT = TextComponent.getText("\u21ba");
    public static final Component EDIT_TEXT = TextComponent.getText("\u270e");
    public static final Component DONE_TEXT = TextComponent.getText("\u2714");
    private static final int DEFAULT_WIDTH = 170;
    private static final int DEFAULT_HEIGHT = 14;
    private static final int DECREASE_BUTTON_WIDTH = 12;
    private static final int INCREASE_BUTTON_WIDTH = 12;
    private static final int RESET_BUTTON_WIDTH = 12;
    private static final int EDIT_BUTTON_WIDTH = 12;
    private final SliderButton sliderButton;
    private final TextButton textButtonDecrease;
    private final TextButton textButtonIncrease;
    private final TextButton textButtonReset;
    private final TextButton textButtonEdit;
    private final TextButton textButtonDone;
    private final TextField textField;
    private final SliderButton.Type sliderType;
    private final boolean showButtons;

    public RangeSliderButton(int left, int top, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        this(left, top, 170, 14, value, minValue, maxValue, defaultValue, stepSize, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double defaultValue, SliderButton.Type sliderType, SliderButton.OnChange onChange) {
        this(left, top, width, height, value, SliderButton.getMinValue(sliderType), SliderButton.getMaxValue(sliderType), defaultValue, SliderButton.getStepSize(sliderType), onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double defaultValue, SliderButton.Type sliderType, boolean showButtons, SliderButton.OnChange onChange) {
        this(left, top, width, height, value, SliderButton.getMinValue(sliderType), SliderButton.getMaxValue(sliderType), defaultValue, SliderButton.getStepSize(sliderType), sliderType, showButtons, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.OnChange onChange) {
        this(left, top, width, height, value, minValue, maxValue, defaultValue, stepSize, SliderButton.Type.DOUBLE, true, onChange);
    }

    public RangeSliderButton(int left, int top, int width, int height, double value, double minValue, double maxValue, double defaultValue, double stepSize, SliderButton.Type sliderType, boolean showButtons, SliderButton.OnChange onChange) {
        super(left, top, width, height, (Component)TextComponent.getBlankText());
        Font font = Minecraft.getInstance().font;
        this.sliderType = sliderType;
        this.showButtons = showButtons;
        this.sliderButton = new SliderButton(this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue, button -> this.updateSliderValue(button, onChange), this.sliderType);
        this.textField = switch (this.sliderType) {
            case SliderButton.Type.DEGREE -> new DegreeNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value);
            case SliderButton.Type.POSITION -> new PositionNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue);
            case SliderButton.Type.SCALE -> new ScaleNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value, minValue, maxValue);
            default -> new PositiveNumberField(font, this.showButtons ? left + 12 : left, top, this.getDefaultSliderWidth(), height, value);
        };
        this.textField.setResponder(text -> {
            if (ValueUtils.isDoubleValue(text, minValue, maxValue)) {
                this.sliderButton.setDefaultValue(Double.parseDouble(text));
            }
        });
        this.textButtonDecrease = new TextButton(this.sliderButton.getX() - 12, top, 12, height, DECREASE_TEXT, button -> {
            if (this.sliderButton.getTargetDoubleValue() - stepSize >= minValue) {
                this.sliderButton.setDefaultValue(this.sliderButton.getTargetDoubleValue() - stepSize);
                this.updateTextField();
            }
        });
        this.textButtonDecrease.active = showButtons;
        this.textButtonIncrease = new TextButton(this.sliderButton.getX() + this.sliderButton.getWidth(), top, 12, height, INCREASE_TEXT, button -> {
            if (this.sliderButton.getTargetDoubleValue() + stepSize <= maxValue) {
                this.sliderButton.setDefaultValue(this.sliderButton.getTargetDoubleValue() + stepSize);
                this.updateTextField();
            }
        });
        this.textButtonIncrease.active = showButtons;
        this.textButtonReset = new TextButton(this.textButtonIncrease.getX() + this.textButtonIncrease.getWidth(), top, 12, height, RESET_TEXT, button -> {
            this.sliderButton.setDefaultValue(defaultValue);
            this.updateTextField();
        });
        this.textButtonReset.active = showButtons;
        this.textButtonEdit = new TextButton(this.textButtonReset.getX() + this.textButtonReset.getWidth(), top, 12, height, EDIT_TEXT, this::showTextField);
        this.textButtonEdit.active = showButtons;
        this.textButtonDone = new TextButton(this.textButtonReset.getX() + this.textButtonReset.getWidth(), top, 12, height, DONE_TEXT, this::showSliderButton);
        this.textButtonDone.active = showButtons;
    }

    public void reset() {
        this.sliderButton.reset();
        this.updateTextField();
    }

    public int getDefaultSliderWidth() {
        if (this.showButtons) {
            return this.width - 48;
        }
        return this.width;
    }

    private void updateSliderValue(SliderButton sliderButton, SliderButton.OnChange onChange) {
        onChange.onChange(sliderButton);
    }

    private void updateTextField() {
        String sliderValue;
        switch (this.sliderType) {
            case DEGREE: {
                String string = String.format("%.1f", this.sliderButton.getTargetDoubleValue()).replace(",", ".");
                break;
            }
            default: {
                String string = sliderValue = String.format("%.2f", this.sliderButton.getTargetDoubleValue()).replace(",", ".");
            }
        }
        if (!this.textField.getValue().equals(sliderValue)) {
            this.textField.setValue(sliderValue);
        }
    }

    public void showTextField() {
        this.showTextField(null);
    }

    public void showSliderButton() {
        this.showSliderButton(null);
    }

    private void showTextField(Button button) {
        this.updateTextField();
        this.sliderButton.visible = false;
        this.sliderButton.setFocused(false);
        this.textButtonEdit.visible = false;
        this.textButtonDone.visible = true;
        this.textField.visible = true;
    }

    private void showSliderButton(Button button) {
        this.sliderButton.visible = true;
        this.textButtonEdit.visible = true;
        this.textButtonDone.visible = false;
        this.textField.visible = false;
        this.textField.setFocused(false);
    }

    public float getTargetValue() {
        return this.sliderButton.getTargetValue();
    }

    public void setTargetValue(float newValue) {
        this.sliderButton.setDefaultValue(newValue);
        this.updateTextField();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.sliderButton.isVisible()) {
            this.sliderButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.textField.isVisible()) {
            this.textField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonDecrease.isActive()) {
            this.textButtonDecrease.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonIncrease.isActive()) {
            this.textButtonIncrease.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonReset.isActive()) {
            this.textButtonReset.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textButtonEdit.isActive() && this.textButtonEdit.isVisible()) {
            this.textButtonEdit.render(guiGraphics, mouseX, mouseY, partialTicks);
        } else if (this.textButtonDone.isActive() && this.textButtonDone.isVisible()) {
            this.textButtonDone.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.sliderButton.isVisible() && this.sliderButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.textField.isVisible() && this.textField.mouseClicked(mouseX, mouseY, button)) {
            this.textField.setFocused(true);
            return true;
        }
        this.textButtonDecrease.mouseClicked(mouseX, mouseY, button);
        this.textButtonIncrease.mouseClicked(mouseX, mouseY, button);
        this.textButtonReset.mouseClicked(mouseX, mouseY, button);
        if (this.textButtonEdit.isVisible()) {
            this.textButtonEdit.mouseClicked(mouseX, mouseY, button);
        } else if (this.textButtonDone.isVisible()) {
            this.textButtonDone.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.textField.isVisible()) {
            this.textField.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double x, double y, double scrollDeltaX, double scrollDeltaY) {
        if (this.sliderButton.isVisible()) {
            return this.sliderButton.mouseScrolled(x, y, scrollDeltaX, scrollDeltaY);
        }
        if (this.textField.isVisible()) {
            return this.textField.mouseScrolled(x, y, scrollDeltaX, scrollDeltaY);
        }
        return super.mouseScrolled(x, y, scrollDeltaX, scrollDeltaY);
    }

    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.sliderButton.isVisible() && this.sliderButton.isMouseOver(mouseX, mouseY)) {
            this.sliderButton.triggerOnDrag(mouseX, mouseY, deltaX, deltaY);
        }
    }

    public boolean charTyped(char character, int keyCode) {
        if (this.sliderButton.isVisible()) {
            return this.sliderButton.charTyped(character, keyCode);
        }
        if (this.textField.isVisible()) {
            return this.textField.charTyped(character, keyCode);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int unused1, int unused2) {
        if (this.sliderButton.isVisible()) {
            return this.sliderButton.keyPressed(keyCode, unused1, unused2);
        }
        if (this.textField.isVisible()) {
            return this.textField.keyPressed(keyCode, unused1, unused2);
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            String usageKey = this.isFocused() ? "narration.slider.usage.focused" : "narration.slider.usage.hovered";
            narrationElementOutput.add(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw(usageKey));
        }
    }
}

