/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.skin.VariantTexture;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class LivingEntityTextureManager {
    private LivingEntityTextureManager() {
    }

    public static ResourceLocation getTextureByVariant(Enum<?> variant, ResourceLocation defaultTexture) {
        if (variant instanceof VariantTexture) {
            VariantTexture variantTexture = (VariantTexture)((Object)variant);
            return variantTexture.getTextureLocation();
        }
        return defaultTexture;
    }

    public static ResourceLocation getCustomTexture(SkinDataCapable<?> entity, ResourceLocation defaultTexture) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, defaultTexture);
    }

    public static ResourceLocation getPlayerTexture(SkinDataCapable<?> entity, ResourceLocation defaultTexture) {
        return PlayerTextureManager.getOrCreateTextureWithDefault(entity, defaultTexture);
    }

    public static ResourceLocation getRemoteTexture(SkinDataCapable<?> entity, ResourceLocation defaultTexture) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, defaultTexture);
    }

    public static ResourceLocation getEntityTexture(EasyNPC<?> easyNPC, ResourceLocation defaultTexture) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> LivingEntityTextureManager.getCustomTexture(skinData, defaultTexture);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> LivingEntityTextureManager.getRemoteTexture(skinData, defaultTexture);
            default -> LivingEntityTextureManager.getTextureByVariant(easyNPC.getEasyNPCVariantData().getSkinVariantType(), defaultTexture);
        };
    }

    public static ResourceLocation getEntityPlayerTexture(EasyNPC<?> easyNPC, ResourceLocation defaultTexture) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> LivingEntityTextureManager.getCustomTexture(skinData, defaultTexture);
            case SkinType.PLAYER_SKIN -> LivingEntityTextureManager.getPlayerTexture(skinData, defaultTexture);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> LivingEntityTextureManager.getRemoteTexture(skinData, defaultTexture);
            default -> LivingEntityTextureManager.getTextureByVariant(easyNPC.getEasyNPCVariantData().getSkinVariantType(), defaultTexture);
        };
    }

    public static ResourceLocation getEntityTextureWithDefaultCallback(EasyNPC<?> easyNPC, ResourceLocation defaultTexture, Supplier<ResourceLocation> defaultTextureSupplier) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> LivingEntityTextureManager.getCustomTexture(skinData, defaultTexture);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> LivingEntityTextureManager.getRemoteTexture(skinData, defaultTexture);
            default -> defaultTextureSupplier.get();
        };
    }
}

