/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.io.DataFileHandler;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static void registerBackupData() {
        Path backupFolder = DataFileHandler.getBackupFolder();
        if (backupFolder == null) {
            return;
        }
        Path backupDataFolder = BackupDataFiles.getBackupDataFolder();
        if (backupDataFolder == null) {
            log.error("Backup data folder is null, unable to register backup data!");
        }
    }

    public static Path getBackupDataFolder() {
        return DataFileHandler.getOrCreateBackupFolder(DATE_FORMATTER.format(LocalDate.now()));
    }

    public static Path getBackupFile(UUID uuid, Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String dateString = DATE_FORMATTER.format(localDate);
        String backupFileName = String.format("%s_%s.backup.npc.nbt", dateString, uuid);
        Path backupDataFolder = DataFileHandler.getOrCreateBackupFolder(dateString);
        return backupDataFolder != null ? backupDataFolder.resolve(backupFileName) : null;
    }
}

