/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public interface EasyNPCEntityRenderer {
    public ResourceLocation getTextureByVariant(Enum<?> var1);

    public ResourceLocation getDefaultTexture();

    default public ResourceLocation getCustomTexture(SkinDataCapable<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getPlayerTexture(SkinDataCapable<?> entity) {
        return PlayerTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getRemoteTexture(SkinDataCapable<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getEntityTexture(EasyNPC<?> easyNPC) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariantType());
        };
    }

    default public ResourceLocation getEntityPlayerTexture(EasyNPC<?> easyNPC) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.PLAYER_SKIN -> this.getPlayerTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariantType());
        };
    }

    default public ResourceLocation getEntityTextureWithDefaultCallback(EasyNPC<?> easyNPC, Supplier<ResourceLocation> defaultTextureSupplier) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> defaultTextureSupplier.get();
        };
    }
}

