/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.server.level.ServerPlayer;

public class EasyNPCSuggestions {
    private EasyNPCSuggestions() {
    }

    public static Stream<String> suggestUUID(ServerPlayer serverPlayer) {
        return serverPlayer.isCreative() ? LivingEntityManager.getUUIDStrings() : LivingEntityManager.getUUIDStringsByOwner(serverPlayer);
    }

    public static Stream<String> suggestUUID(String startWith) {
        return LivingEntityManager.getUUIDStrings().filter(uuid -> uuid.startsWith(startWith));
    }

    public static CompletableFuture<Suggestions> suggestUUID(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return SharedSuggestionProvider.suggest(EasyNPCSuggestions.suggestUUID(serverPlayer), (SuggestionsBuilder)build);
    }
}

