/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradingOfferHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private TradingOfferHandler() {
    }

    public static void setAdvancedTradingMaxUses(TradingDataCapable<?> tradingData, int tradingOfferIndex, int maxUses) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingOfferHandler.getItemCost(merchantOffer.getBaseCostA()), TradingOfferHandler.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), 0, maxUses, merchantOffer.getXp(), merchantOffer.getPriceMultiplier(), merchantOffer.getDemand()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingXp(TradingDataCapable<?> tradingData, int tradingOfferIndex, int xp) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingOfferHandler.getItemCost(merchantOffer.getBaseCostA()), TradingOfferHandler.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), merchantOffer.getUses(), merchantOffer.getMaxUses(), xp, merchantOffer.getPriceMultiplier(), merchantOffer.getDemand()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingPriceMultiplier(TradingDataCapable<?> tradingData, int tradingOfferIndex, float priceMultiplier) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingOfferHandler.getItemCost(merchantOffer.getBaseCostA()), TradingOfferHandler.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), merchantOffer.getUses(), merchantOffer.getMaxUses(), merchantOffer.getXp(), priceMultiplier, merchantOffer.getDemand()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingDemand(TradingDataCapable<?> tradingData, int tradingOfferIndex, int demand) {
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingOfferHandler.getItemCost(merchantOffer.getBaseCostA()), TradingOfferHandler.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), merchantOffer.getUses(), merchantOffer.getMaxUses(), merchantOffer.getXp(), merchantOffer.getPriceMultiplier(), demand));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void updateBasicTradingOffers(TradingDataCapable<?> tradingData) {
        if (tradingData.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        MerchantOffers newMerchantOffers = new MerchantOffers();
        for (MerchantOffer merchantOffer : merchantOffers) {
            if (!TradingOfferHandler.isValidTradingOffer(merchantOffer.getBaseCostA(), merchantOffer.getCostB(), merchantOffer.getResult())) continue;
            MerchantOffer newMerchantOffer = new MerchantOffer(TradingOfferHandler.getItemCost(merchantOffer.getBaseCostA()), TradingOfferHandler.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), tradingData.getTradingDataSet().getMaxUses(), tradingData.getTradingDataSet().getRewardedXP(), merchantOffer.getPriceMultiplier());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        tradingData.setTradingOffers(newMerchantOffers);
    }

    private static boolean isValidTradingOffer(ItemStack itemA, ItemStack itemB, ItemStack itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.isEmpty() || itemB != null && !itemB.isEmpty()) && !itemResult.isEmpty();
    }

    private static ItemCost getItemCost(ItemStack itemStack) {
        return new ItemCost((ItemLike)(itemStack.isEmpty() ? ItemStack.EMPTY.getItem() : itemStack.getItem()), itemStack.getCount());
    }

    private static Optional<ItemCost> getOptionalItemCost(ItemStack itemStack) {
        return itemStack.isEmpty() ? Optional.empty() : Optional.of(TradingOfferHandler.getItemCost(itemStack));
    }
}

