/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.spawner;

import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.config.SpawnerTypeConfig;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerData {
    public static final String DELAY_TAG = "Delay";
    public static final String MIN_SPAWN_DELAY_TAG = "MinSpawnDelay";
    public static final String MAX_SPAWN_DELAY_TAG = "MaxSpawnDelay";
    public static final String SPAWN_COUNT_TAG = "SpawnCount";
    public static final String MAX_NEARBY_ENTITIES_TAG = "MaxNearbyEntities";
    public static final String REQUIRED_PLAYER_RANGE_TAG = "RequiredPlayerRange";
    public static final String SPAWN_RANGE_TAG = "SpawnRange";
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static void setDelay(class_2487 compoundTag, short spawnDelay) {
        compoundTag.method_10575(DELAY_TAG, spawnDelay);
    }

    public static short getDelay(class_2487 compoundTag) {
        return compoundTag.method_10568(DELAY_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_DELAY);
    }

    public static void setMinSpawnDelay(class_2487 compoundTag, short minSpawnDelay) {
        compoundTag.method_10575(MIN_SPAWN_DELAY_TAG, minSpawnDelay);
    }

    public static short getMinSpawnDelay(class_2487 compoundTag) {
        return compoundTag.method_10568(MIN_SPAWN_DELAY_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_MIN_SPAWN_DELAY);
    }

    public static boolean hasMinSpawnDelay(class_2487 compoundTag) {
        return compoundTag.method_10545(MIN_SPAWN_DELAY_TAG);
    }

    public static void setMaxSpawnDelay(class_2487 compoundTag, short maxSpawnDelay) {
        compoundTag.method_10575(MAX_SPAWN_DELAY_TAG, maxSpawnDelay);
    }

    public static short getMaxSpawnDelay(class_2487 compoundTag) {
        return compoundTag.method_10568(MAX_SPAWN_DELAY_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_SPAWN_DELAY);
    }

    public static void setSpawnCount(class_2487 compoundTag, short spawnCount) {
        compoundTag.method_10575(SPAWN_COUNT_TAG, spawnCount);
    }

    public static short getSpawnCount(class_2487 compoundTag) {
        return compoundTag.method_10568(SPAWN_COUNT_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_COUNT);
    }

    public static void setMaxNearbyEntities(class_2487 compoundTag, short maxNearbyEntities) {
        compoundTag.method_10575(MAX_NEARBY_ENTITIES_TAG, maxNearbyEntities);
    }

    public static short getMaxNearbyEntities(class_2487 compoundTag) {
        return compoundTag.method_10568(MAX_NEARBY_ENTITIES_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES);
    }

    public static boolean hasMaxNearbyEntities(class_2487 compoundTag) {
        return compoundTag.method_10545(MAX_NEARBY_ENTITIES_TAG);
    }

    public static void setRequiredPlayerRange(class_2487 compoundTag, short requiredPlayerRange) {
        compoundTag.method_10575(REQUIRED_PLAYER_RANGE_TAG, requiredPlayerRange);
    }

    public static short getRequiredPlayerRange(class_2487 compoundTag) {
        return compoundTag.method_10568(REQUIRED_PLAYER_RANGE_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE);
    }

    public static void setSpawnRange(class_2487 compoundTag, short spawnRange) {
        compoundTag.method_10575(SPAWN_RANGE_TAG, spawnRange);
    }

    public static short getSpawnRange(class_2487 compoundTag) {
        return compoundTag.method_10568(SPAWN_RANGE_TAG).orElse(SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_RANGE);
    }

    public static boolean hasSpawnRange(class_2487 compoundTag) {
        return compoundTag.method_10545(SPAWN_RANGE_TAG);
    }

    public static class_1952 getSpawnData(class_2487 compoundTag) {
        if (!SpawnerData.hasSpawnData(compoundTag)) {
            return new class_1952();
        }
        class_2487 spawnData = compoundTag.method_68568(SPAWN_DATA_TAG);
        return class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)spawnData).resultOrPartial(result -> log.warn("Invalid SpawnData: {}", result)).orElseGet(class_1952::new);
    }

    public static boolean hasSpawnData(class_2487 compoundTag) {
        return compoundTag.method_10545(SPAWN_DATA_TAG);
    }

    public static boolean setSpawnerValue(class_2487 compoundTag, String parameter, short value) {
        switch (parameter) {
            case "Delay": {
                SpawnerData.setDelay(compoundTag, value);
                break;
            }
            case "MinSpawnDelay": {
                SpawnerData.setMinSpawnDelay(compoundTag, value);
                break;
            }
            case "MaxSpawnDelay": {
                SpawnerData.setMaxSpawnDelay(compoundTag, value);
                break;
            }
            case "SpawnCount": {
                SpawnerData.setSpawnCount(compoundTag, value);
                break;
            }
            case "MaxNearbyEntities": {
                SpawnerData.setMaxNearbyEntities(compoundTag, value);
                break;
            }
            case "RequiredPlayerRange": {
                SpawnerData.setRequiredPlayerRange(compoundTag, value);
                break;
            }
            case "SpawnRange": {
                SpawnerData.setSpawnRange(compoundTag, value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void setSpawnData(SpawnerType spawnerType, class_2487 compoundTag) {
        switch (spawnerType) {
            case BOSS_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.BOSS_SPAWNER_SPAWN_RANGE);
                break;
            }
            case DEFAULT_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.DEFAULT_SPAWNER_SPAWN_RANGE);
                break;
            }
            case GROUP_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.GROUP_SPAWNER_SPAWN_RANGE);
                break;
            }
            case SINGLE_SPAWNER: {
                SpawnerData.setDelay(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_DELAY);
                SpawnerData.setMinSpawnDelay(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_MIN_SPAWN_DELAY);
                SpawnerData.setMaxSpawnDelay(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_MAX_SPAWN_DELAY);
                SpawnerData.setSpawnCount(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_SPAWN_COUNT);
                SpawnerData.setMaxNearbyEntities(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_MAX_NEARBY_ENTITIES);
                SpawnerData.setRequiredPlayerRange(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_REQUIRED_PLAYER_RANGE);
                SpawnerData.setSpawnRange(compoundTag, SpawnerTypeConfig.SINGLE_SPAWNER_SPAWN_RANGE);
            }
        }
    }
}

