/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.armpose;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;

public class ModelArmPoseUtils {
    public static ModelArmPose getArmPoseForLeftArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.calculateArmPose(easyNPC, false);
    }

    public static ModelArmPose getArmPoseForRightArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.calculateArmPose(easyNPC, true);
    }

    private static ModelArmPose calculateArmPose(EasyNPC<?> easyNPC, boolean isRightArm) {
        boolean isRightHanded;
        if (easyNPC == null) {
            return ModelArmPose.DEFAULT;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        boolean bl = isRightHanded = livingEntity.getMainArm() == HumanoidArm.RIGHT;
        if (livingEntity.isUsingItem()) {
            return ModelArmPoseUtils.getArmPoseWhileUsingItem(livingEntity, isRightArm, isRightHanded);
        }
        return ModelArmPoseUtils.getIdleArmPose(easyNPC, livingEntity, isRightArm, isRightHanded);
    }

    private static ModelArmPose getArmPoseWhileUsingItem(LivingEntity livingEntity, boolean isRightArm, boolean isRightHanded) {
        boolean isUsingRightHand;
        ItemStack useItem = livingEntity.getUseItem();
        if (useItem.isEmpty()) {
            return ModelArmPose.DEFAULT;
        }
        InteractionHand usedHand = livingEntity.getUsedItemHand();
        boolean isUsingMainHand = usedHand == InteractionHand.MAIN_HAND;
        boolean bl = isUsingRightHand = isRightHanded && isUsingMainHand || !isRightHanded && !isUsingMainHand;
        if (isRightArm != isUsingRightHand) {
            return ModelArmPose.DEFAULT;
        }
        ItemUseAnimation itemUseAnimation = useItem.getUseAnimation();
        switch (itemUseAnimation) {
            case BOW: {
                return ModelArmPose.BOW_AND_ARROW;
            }
            case CROSSBOW: {
                return ModelArmPose.CROSSBOW_CHARGE;
            }
            case SPYGLASS: {
                return ModelArmPose.SPYGLASS;
            }
            case SPEAR: {
                return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
            }
        }
        return ModelArmPose.DEFAULT;
    }

    private static ModelArmPose getIdleArmPose(EasyNPC<?> easyNPC, LivingEntity livingEntity, boolean isRightArm, boolean isRightHanded) {
        ItemStack currentArmItem;
        Mob mob;
        boolean isAggressive;
        boolean bl = isAggressive = easyNPC.getPathfinderMob().getTarget() != null || livingEntity instanceof Mob && (mob = (Mob)livingEntity).isAggressive();
        if (!isAggressive) {
            return ModelArmPose.DEFAULT;
        }
        ItemStack mainHandItem = livingEntity.getMainHandItem();
        ItemStack offHandItem = livingEntity.getOffhandItem();
        ItemStack itemInRightArm = isRightHanded ? mainHandItem : offHandItem;
        ItemStack itemInLeftArm = isRightHanded ? offHandItem : mainHandItem;
        ItemStack itemStack = currentArmItem = isRightArm ? itemInRightArm : itemInLeftArm;
        if (currentArmItem.isEmpty()) {
            return ModelArmPose.DEFAULT;
        }
        if (currentArmItem.getItem() instanceof CrossbowItem) {
            return ModelArmPose.CROSSBOW_HOLD;
        }
        if (AttackHandler.isBowWeapon(currentArmItem)) {
            return ModelArmPose.BOW_AND_ARROW;
        }
        if (AttackHandler.isGunWeapon(currentArmItem)) {
            return ModelArmPose.GUN_HOLD;
        }
        if (AttackHandler.isMeeleeWeapon(currentArmItem)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return ModelArmPose.DEFAULT;
    }
}

