/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.IronGolemRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.state.IronGolemRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class IronGolemRawRenderer
extends IronGolemRenderer
implements EasyNPCEntityRenderer {
    protected static final Map<IronGolemRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(IronGolemRaw.VariantType.class), map -> {
        map.put(IronGolemRaw.VariantType.IRON_GOLEM, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/iron_golem/iron_golem.png"));
        map.put(IronGolemRaw.VariantType.IRON_GOLEM_CRACKINESS_LOW, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/iron_golem/iron_golem.png"));
        map.put(IronGolemRaw.VariantType.IRON_GOLEM_CRACKINESS_MEDIUM, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/iron_golem/iron_golem.png"));
        map.put(IronGolemRaw.VariantType.IRON_GOLEM_CRACKINESS_HIGH, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/iron_golem/iron_golem.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)IronGolemRaw.VariantType.IRON_GOLEM);

    public IronGolemRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(IronGolemRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

