/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.attribute.CombatAttributes;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.item.ModItemTags;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.ItemLike;

public class AttackHandler {
    private AttackHandler() {
    }

    public static boolean isMeeleeWeapon(ItemStack itemStack) {
        return itemStack.getItem() instanceof SwordItem || itemStack.getItem() instanceof AxeItem;
    }

    public static boolean isBowWeapon(ItemStack itemStack) {
        return itemStack.getItem() instanceof BowItem || itemStack.is(ModItemTags.RANGED_WEAPON_BOW);
    }

    public static boolean isCrossbowWeapon(ItemStack itemStack) {
        return itemStack.getItem() instanceof CrossbowItem || itemStack.is(ModItemTags.RANGED_WEAPON_CROSSBOW);
    }

    public static boolean isGunWeapon(ItemStack itemStack) {
        return itemStack.is(ModItemTags.RANGED_WEAPON_GUN);
    }

    public static boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem instanceof CrossbowItem || projectileWeaponItem instanceof BowItem;
    }

    public static boolean isHoldingBowWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isBowWeapon(livingEntity.getMainHandItem());
    }

    public static boolean isHoldingCrossbowWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isCrossbowWeapon(livingEntity.getMainHandItem());
    }

    public static boolean isHoldingGunWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isGunWeapon(livingEntity.getMainHandItem());
    }

    public static boolean isHoldingMeleeWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isMeeleeWeapon(livingEntity.getMainHandItem());
    }

    public static boolean isHoldingProjectileWeapon(LivingEntity livingEntity) {
        return livingEntity != null && livingEntity.getMainHandItem().getItem() instanceof ProjectileWeaponItem;
    }

    public static boolean isHoldingWeapon(LivingEntity livingEntity) {
        return AttackHandler.isHoldingMeleeWeapon(livingEntity) || AttackHandler.isHoldingProjectileWeapon(livingEntity);
    }

    public static void addChargedProjectile(ItemStack weaponItemStack, ItemStack projectileItemStack) {
        weaponItemStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((ItemStack)projectileItemStack));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void performDefaultRangedAttack(LivingEntity livingEntity, LivingEntity targedtedLivingEntity, float damage) {
        if (AttackHandler.isHoldingBowWeapon(livingEntity)) {
            AttackHandler.performBowAttack(livingEntity, targedtedLivingEntity, damage);
            return;
        }
        if (livingEntity instanceof CrossbowAttackMob) {
            CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)livingEntity;
            if (AttackHandler.isHoldingCrossbowWeapon(livingEntity)) {
                AttackHandler.addChargedProjectile(livingEntity.getMainHandItem(), new ItemStack((ItemLike)Items.ARROW, 1));
                crossbowAttackMob.performCrossbowAttack(livingEntity, 1.6f);
                return;
            }
        }
        if (!AttackHandler.isHoldingGunWeapon(livingEntity)) return;
        AttackHandler.performGunAttack(livingEntity, targedtedLivingEntity, damage);
    }

    public static InteractionHand getBowHoldingHand(LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.getMainHandItem();
        return AttackHandler.isBowWeapon(itemStack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static InteractionHand getCrossbowHoldingHand(LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.getMainHandItem();
        return AttackHandler.isCrossbowWeapon(itemStack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static InteractionHand getGunHoldingHand(LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.getMainHandItem();
        return AttackHandler.isGunWeapon(itemStack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static void performGunAttack(LivingEntity livingEntity, LivingEntity livingEntityTarget, float damage) {
        ItemStack itemStackWeapon = livingEntity.getItemInHand(AttackHandler.getGunHoldingHand(livingEntity));
        AbstractArrow abstractArrow = AttackHandler.getBullet(livingEntity, itemStackWeapon, damage);
        if (AttackHandler.isGunWeapon(livingEntity.getMainHandItem())) {
            double targetX = livingEntityTarget.getX() - livingEntity.getX();
            double targetY = livingEntityTarget.getY() - abstractArrow.getY();
            double targetZ = livingEntityTarget.getZ() - livingEntity.getZ();
            double targetRadius = Math.sqrt(targetX * targetX + targetZ * targetZ);
            abstractArrow.shoot(targetX, targetY + targetRadius * (double)0.2f, targetZ, 1.6f, 14.0f - (float)(livingEntity.level().getDifficulty().getId() * 4));
            livingEntity.playSound(SoundEvents.FIRECHARGE_USE, 1.0f, 1.0f / (livingEntity.getRandom().nextFloat() * 0.4f + 0.8f));
            livingEntity.level().addFreshEntity((Entity)abstractArrow);
        }
    }

    public static void performBowAttack(LivingEntity livingEntity, LivingEntity livingEntityTarget, float damage) {
        ItemStack itemStackWeapon = livingEntity.getItemInHand(AttackHandler.getBowHoldingHand(livingEntity));
        ItemStack itemStackProjectile = livingEntity.getProjectile(itemStackWeapon);
        AbstractArrow abstractArrow = AttackHandler.getArrow(livingEntity, itemStackWeapon, itemStackProjectile, damage);
        if (AttackHandler.isBowWeapon(livingEntity.getMainHandItem())) {
            double targetX = livingEntityTarget.getX() - livingEntity.getX();
            double targetY = livingEntityTarget.getY(0.3333333333333333) - abstractArrow.getY();
            double targetZ = livingEntityTarget.getZ() - livingEntity.getZ();
            double targetRadius = Math.sqrt(targetX * targetX + targetZ * targetZ);
            abstractArrow.shoot(targetX, targetY + targetRadius * (double)0.2f, targetZ, 1.6f, 14.0f - (float)(livingEntity.level().getDifficulty().getId() * 4));
            livingEntity.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (livingEntity.getRandom().nextFloat() * 0.4f + 0.8f));
            livingEntity.level().addFreshEntity((Entity)abstractArrow);
        }
    }

    public static AbstractArrow getArrow(LivingEntity livingEntity, ItemStack itemStackWeapon, ItemStack itemStackProjectile, float damage) {
        return ProjectileUtil.getMobArrow((LivingEntity)livingEntity, (ItemStack)itemStackProjectile, (float)damage, (ItemStack)itemStackWeapon);
    }

    public static AbstractArrow getBullet(LivingEntity livingEntity, ItemStack itemStackWeapon, float damage) {
        Optional item = BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"bullet"));
        return item.map(itemReference -> ProjectileUtil.getMobArrow((LivingEntity)livingEntity, (ItemStack)new ItemStack((Holder)itemReference), (float)damage, (ItemStack)itemStackWeapon)).orElseGet(() -> ProjectileUtil.getMobArrow((LivingEntity)livingEntity, (ItemStack)new ItemStack((ItemLike)Items.ARROW), (float)damage, (ItemStack)itemStackWeapon));
    }

    public static boolean handleIsInvulnerableTo(EasyNPCBase<?> easyNPC, DamageSource damageSource, boolean defaultValue) {
        if (easyNPC.getEntityAttributes().getCombatAttributes().isInvulnerable()) {
            return true;
        }
        CombatAttributes combatAttributes = easyNPC.getEntityAttributes().getCombatAttributes();
        if (damageSource.getEntity() instanceof Player) {
            return !combatAttributes.isAttackableByPlayers();
        }
        if (damageSource.getEntity() instanceof Monster) {
            return !combatAttributes.isAttackableByMonsters();
        }
        return defaultValue;
    }
}

