/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.ZombieRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ZombieNPC
extends ZombieRaw
implements StandardEasyNPC<ZombieRaw> {
    public static final String ID = "zombie";
    public static final String ID_HUSK = "husk";

    public ZombieNPC(EntityType<? extends Zombie> entityType, Level level) {
        this(entityType, level, ZombieRaw.VariantType.ZOMBIE);
    }

    public ZombieNPC(EntityType<? extends Zombie> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.setInvulnerable(true);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
        this.refreshGroundNavigation();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return true;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        ZombieRaw.VariantType soundVariant = ZombieRaw.VariantType.valueOf(variantName);
        switch (soundVariant) {
            case HUSK: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.HUSK_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.HUSK_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.HUSK_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.HUSK_STEP);
                break;
            }
            default: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.ZOMBIE_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.ZOMBIE_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.ZOMBIE_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.ZOMBIE_STEP);
            }
        }
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void randomizeReinforcementsChance() {
    }

    protected void registerGoals() {
    }

    protected void addBehaviourGoals() {
    }

    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

