/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.easynpc.npc.raw.SkeletonRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.VillagerRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.ZombieRaw;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NPCEntityFactory {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<EntityType<?>, BiFunction<EntityType<?>, Level, Entity>> entityConstructors = new HashMap();

    private NPCEntityFactory() {
    }

    public static Entity createEntityFromBaseType(EntityType<?> baseEntityType, EntityType<?> targetEntityType, Level level) {
        BiFunction<EntityType<?>, Level, Entity> constructor = entityConstructors.get(baseEntityType);
        if (constructor == null) {
            throw new IllegalArgumentException("Unsupported base entity type: " + NPCEntityFactory.getEntityTypeId(baseEntityType) + ". Supported types are: " + String.valueOf(NPCEntityFactory.getSupportedBaseTypeIds()));
        }
        try {
            Entity entity = constructor.apply(targetEntityType, level);
            if (entity == null) {
                throw new IllegalStateException("Constructor for base type " + NPCEntityFactory.getEntityTypeId(baseEntityType) + " returned null entity");
            }
            return entity;
        }
        catch (Exception e) {
            log.error("Failed to create entity from base type {}: {}", (Object)NPCEntityFactory.getEntityTypeId(baseEntityType), (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to create entity from base type " + NPCEntityFactory.getEntityTypeId(baseEntityType), e);
        }
    }

    public static boolean isBaseTypeSupported(EntityType<?> baseEntityType) {
        return entityConstructors.containsKey(baseEntityType);
    }

    public static String[] getSupportedBaseTypeIds() {
        return (String[])entityConstructors.keySet().stream().map(NPCEntityFactory::getEntityTypeId).toArray(String[]::new);
    }

    public static void registerEntityConstructor(EntityType<?> baseEntityType, BiFunction<EntityType<?>, Level, Entity> constructor) {
        entityConstructors.put(baseEntityType, constructor);
        log.debug("Registered entity constructor for base type: {}", (Object)NPCEntityFactory.getEntityTypeId(baseEntityType));
    }

    private static void initializeEntityConstructors() {
        NPCEntityFactory.registerEntityConstructor(EntityType.f_20501_, (type, level) -> new ZombieRaw((EntityType<? extends Zombie>)type, (Level)level));
        NPCEntityFactory.registerEntityConstructor(EntityType.f_20492_, (type, level) -> new VillagerRaw((EntityType<? extends Villager>)type, (Level)level));
        NPCEntityFactory.registerEntityConstructor(EntityType.f_20524_, (type, level) -> new SkeletonRaw((EntityType<? extends Skeleton>)type, (Level)level));
    }

    private static String getEntityTypeId(EntityType<?> entityType) {
        ResourceLocation resourceLocation = BuiltInRegistries.f_256780_.m_7981_(entityType);
        return resourceLocation.toString();
    }

    static {
        NPCEntityFactory.initializeEntityConstructors();
    }
}

