/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributes;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerDataCapable;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface NavigationDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String DATA_HOME_TAG = "Home";
    public static final String DATA_NAVIGATION_TAG = "Navigation";
    public static final int TRAVEL_EVENT_TICK = 20;

    public static void registerSyncedNavigationData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Navigation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.NAVIGATION_HOME_POSITION, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135038_));
    }

    default public BlockPos getHomePosition() {
        return (BlockPos)this.getSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION);
    }

    default public void setHomePosition(BlockPos blockPos) {
        this.setSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION, blockPos);
    }

    default public boolean hasHomePosition() {
        return this.getHomePosition() != null && !this.getHomePosition().equals((Object)BlockPos.f_121853_);
    }

    default public void setPosition(Vec3 pos) {
        this.getLivingEntity().m_146884_(pos);
        this.getLivingEntity().m_20219_(pos);
    }

    default public void refreshGroundNavigation() {
        EntityAttributes attributeData;
        GroundPathNavigation groundPathNavigation = this.getGroundPathNavigation();
        if (groundPathNavigation == null) {
            return;
        }
        EntityAttributes entityAttributes = attributeData = this.getEasyNPCAttributeData() != null ? this.getEasyNPCAttributeData().getEntityAttributes() : null;
        if (attributeData != null && attributeData.hasMovementAttributes()) {
            groundPathNavigation.m_26477_(attributeData.getMovementAttributes().canOpenDoor());
            groundPathNavigation.m_148214_(attributeData.getMovementAttributes().canPassDoor());
            groundPathNavigation.m_7008_(attributeData.getEnvironmentalAttributes().canFloat());
        } else {
            groundPathNavigation.m_26477_(true);
            groundPathNavigation.m_148214_(true);
            groundPathNavigation.m_7008_(true);
        }
    }

    default public GroundPathNavigation getGroundPathNavigation() {
        Mob mob;
        NavigationDataCapable navigationDataCapable = this;
        if (navigationDataCapable instanceof Mob && (navigationDataCapable = (mob = (Mob)navigationDataCapable).m_21573_()) instanceof GroundPathNavigation) {
            GroundPathNavigation groundPathNavigation = (GroundPathNavigation)navigationDataCapable;
            return groundPathNavigation;
        }
        return null;
    }

    default public void defineSynchedNavigationData() {
        this.defineSynchedEntityData(SynchedDataIndex.NAVIGATION_HOME_POSITION, BlockPos.f_121853_);
    }

    default public boolean canFly() {
        return false;
    }

    default public boolean isFlying() {
        return this.canFly() && !this.getEntity().m_20096_();
    }

    default public void addAdditionalNavigationData(CompoundTag compoundTag) {
        CompoundTag navigationTag = new CompoundTag();
        if (this.hasHomePosition()) {
            navigationTag.m_128365_(DATA_HOME_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.getHomePosition()));
        }
        compoundTag.m_128365_(DATA_NAVIGATION_TAG, (Tag)navigationTag);
    }

    default public void readAdditionalNavigationData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_NAVIGATION_TAG)) {
            return;
        }
        CompoundTag navigationTag = compoundTag.m_128469_(DATA_NAVIGATION_TAG);
        if (navigationTag.m_128441_(DATA_HOME_TAG)) {
            this.setHomePosition(NbtUtils.m_129239_((CompoundTag)navigationTag.m_128469_(DATA_HOME_TAG)));
        }
    }

    default public void handleNavigationTravelEvent(Vec3 vec3) {
        TickerDataCapable tickerData = this.getEasyNPCTickerData();
        if (tickerData.checkAndIncreaseTicker(TickerType.TRAVEL_EVENT, 20)) {
            AttributeDataCapable attributeData;
            EnvironmentalAttributes environmentalAttributes;
            Mob mob = this.getMob();
            Level level = this.getEntityLevel();
            BlockState blockState = level.m_8055_(mob.m_20097_());
            mob.m_6853_(!blockState.m_60713_(Blocks.f_50016_) && !blockState.m_60713_(Blocks.f_50034_) && !blockState.m_60713_(Blocks.f_50336_) && !blockState.m_60713_(Blocks.f_50350_));
            ObjectiveDataCapable objectiveData = this.getEasyNPCObjectiveData();
            if (!objectiveData.hasTravelTargetObjectives() && (environmentalAttributes = (attributeData = this.getEasyNPCAttributeData()).getEntityAttributes().getEnvironmentalAttributes()).freefall() && !environmentalAttributes.noGravity() && !mob.m_20096_()) {
                Vec3 currentPos = mob.m_20182_();
                BlockPos belowPos = mob.m_20097_().m_7495_();
                BlockState belowBlock = level.m_8055_(belowPos);
                if (belowBlock.m_60795_()) {
                    mob.m_6034_(currentPos.f_82479_, Math.max(currentPos.f_82480_, (double)belowPos.m_123342_() + 1.0), currentPos.f_82481_);
                } else {
                    mob.m_6034_(mob.m_20185_(), Math.floor(mob.m_20186_() - 0.1), mob.m_20189_());
                }
            }
            tickerData.resetTicker(TickerType.TRAVEL_EVENT);
        }
    }
}

