/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.armpose;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class ModelArmPoseUtils {
    public static ModelArmPose getArmPoseForLeftArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.getArmPose(easyNPC, false);
    }

    public static ModelArmPose getArmPoseForRightArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.getArmPose(easyNPC, true);
    }

    private static ModelArmPose getArmPose(EasyNPC<?> easyNPC, boolean isRightArm) {
        boolean isRightHanded;
        if (easyNPC == null) {
            return ModelArmPose.DEFAULT;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        boolean bl = isRightHanded = livingEntity.getMainArm() == HumanoidArm.RIGHT;
        if (livingEntity.isUsingItem()) {
            return ModelArmPoseUtils.getArmPoseWhileUsingItem(livingEntity, isRightArm, isRightHanded);
        }
        return ModelArmPoseUtils.getIdleArmPose(easyNPC, livingEntity, isRightArm, isRightHanded);
    }

    private static ModelArmPose getArmPoseWhileUsingItem(LivingEntity livingEntity, boolean isRightArm, boolean isRightHanded) {
        boolean isUsingRightHand;
        ModelArmPose itemUseModelArmPose;
        ItemStack useItem = livingEntity.getUseItem();
        if (useItem.isEmpty()) {
            return ModelArmPose.DEFAULT;
        }
        switch (useItem.getUseAnimation()) {
            case BOW: {
                ModelArmPose modelArmPose = ModelArmPose.BOW_AND_ARROW;
                break;
            }
            case CROSSBOW: {
                ModelArmPose modelArmPose = ModelArmPose.CROSSBOW_CHARGE;
                break;
            }
            case SPYGLASS: {
                ModelArmPose modelArmPose = ModelArmPose.SPYGLASS;
                break;
            }
            case SPEAR: {
                ModelArmPose modelArmPose = ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
                break;
            }
            default: {
                ModelArmPose modelArmPose = itemUseModelArmPose = ModelArmPose.DEFAULT;
            }
        }
        if (itemUseModelArmPose == ModelArmPose.BOW_AND_ARROW || itemUseModelArmPose == ModelArmPose.CROSSBOW_CHARGE) {
            return itemUseModelArmPose;
        }
        if (AttackHandler.isGunWeapon(useItem)) {
            return ModelArmPose.GUN_HOLD;
        }
        boolean isUsingMainHand = livingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND;
        boolean bl = isUsingRightHand = isRightHanded && isUsingMainHand || !isRightHanded && !isUsingMainHand;
        if (isRightArm != isUsingRightHand) {
            return ModelArmPose.DEFAULT;
        }
        return itemUseModelArmPose;
    }

    private static ModelArmPose getIdleArmPose(EasyNPC<?> easyNPC, LivingEntity livingEntity, boolean isRightArm, boolean isRightHanded) {
        ItemStack currentArmItem;
        Mob mob;
        if (!(easyNPC.getPathfinderMob().getTarget() != null || livingEntity instanceof Mob && (mob = (Mob)livingEntity).isAggressive())) {
            return ModelArmPose.DEFAULT;
        }
        ItemStack mainHandItem = livingEntity.getMainHandItem();
        ItemStack offHandItem = livingEntity.getOffhandItem();
        if (!mainHandItem.isEmpty()) {
            if (mainHandItem.getItem() instanceof CrossbowItem) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
            if (AttackHandler.isBowWeapon(mainHandItem)) {
                return ModelArmPose.BOW_AND_ARROW;
            }
            if (AttackHandler.isGunWeapon(mainHandItem)) {
                return ModelArmPose.GUN_HOLD;
            }
        }
        if (!offHandItem.isEmpty()) {
            if (offHandItem.getItem() instanceof CrossbowItem) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
            if (AttackHandler.isBowWeapon(offHandItem)) {
                return ModelArmPose.BOW_AND_ARROW;
            }
            if (AttackHandler.isGunWeapon(offHandItem)) {
                return ModelArmPose.GUN_HOLD;
            }
        }
        ItemStack itemInRightArm = isRightHanded ? mainHandItem : offHandItem;
        ItemStack itemInLeftArm = isRightHanded ? offHandItem : mainHandItem;
        ItemStack itemStack = currentArmItem = isRightArm ? itemInRightArm : itemInLeftArm;
        if (!currentArmItem.isEmpty() && AttackHandler.isMeleeWeapon(currentArmItem)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return ModelArmPose.DEFAULT;
    }
}

