/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCLivingEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.client.texture.LivingEntityTextureManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public interface EasyNPCEntityRenderer {
    public ResourceLocation getDefaultTexture();

    default public boolean supportsPlayerSkins() {
        return false;
    }

    default public boolean hasEasyNPCRenderState(LivingEntityRenderState livingEntityRenderState) {
        return livingEntityRenderState instanceof EasyNPCRenderStateExtension;
    }

    default public ResourceLocation getTextureByVariant(Enum<?> variant) {
        return LivingEntityTextureManager.getTextureByVariant(variant, this.getDefaultTexture());
    }

    default public ResourceLocation getCustomTexture(SkinDataCapable<?> entity) {
        return LivingEntityTextureManager.getCustomTexture(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getPlayerTexture(SkinDataCapable<?> entity) {
        return LivingEntityTextureManager.getPlayerTexture(entity, this.getDefaultTexture());
    }

    default public ResourceLocation getRemoteTexture(SkinDataCapable<?> entity) {
        return LivingEntityTextureManager.getRemoteTexture(entity, this.getDefaultTexture());
    }

    default public EasyNPC<?> getEasyNPC(LivingEntityRenderState livingEntityRenderState) {
        return EasyNPCLivingEntityRenderer.getEasyNPC(livingEntityRenderState);
    }

    default public ResourceLocation getTextureFromRenderState(LivingEntityRenderState renderState) {
        return EasyNPCLivingEntityRenderer.getTexture(renderState, this.getDefaultTexture());
    }

    default public ResourceLocation getEntityTexture(EasyNPC<?> easyNPC) {
        return LivingEntityTextureManager.getEntityTexture(easyNPC, this.getDefaultTexture());
    }

    default public ResourceLocation getEntityPlayerTexture(EasyNPC<?> easyNPC) {
        return LivingEntityTextureManager.getEntityPlayerTexture(easyNPC, this.getDefaultTexture());
    }

    default public ResourceLocation getEntityTextureWithDefaultCallback(EasyNPC<?> easyNPC, Supplier<ResourceLocation> defaultTextureSupplier) {
        return LivingEntityTextureManager.getEntityTextureWithDefaultCallback(easyNPC, this.getDefaultTexture(), defaultTextureSupplier);
    }
}

