/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.preset.PresetData;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import de.markusbordihn.easynpc.utils.SpawnerUtils;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCPresetItem
extends Item {
    public static final String NAME = "easy_npc_preset";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String CUSTOM_NAME_TAG = "CustomName";
    private static final String TEXT_TAG = "text";

    public EasyNPCPresetItem(Item.Properties properties) {
        super(properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)NAME))));
    }

    public static UUID getPresetUUID(ItemStack itemStack) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || presetData.data() == null) {
            return null;
        }
        CompoundTag compoundTag = presetData.data();
        return CompoundTagUtils.readUUID(compoundTag, "PresetUUID");
    }

    public static String getCustomName(ItemStack itemStack) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || presetData.data() == null) {
            return null;
        }
        CompoundTag compoundTag = presetData.data();
        if (compoundTag.contains(CUSTOM_NAME_TAG)) {
            CompoundTag customNameTag = compoundTag.getCompoundOrEmpty(CUSTOM_NAME_TAG);
            if (customNameTag.contains(TEXT_TAG)) {
                return customNameTag.getString(TEXT_TAG).orElse("");
            }
            try {
                JsonObject jsonObject;
                JsonElement jsonElement;
                String customNameString = compoundTag.getString(CUSTOM_NAME_TAG).orElse("");
                if (!customNameString.isEmpty() && (jsonElement = JsonParser.parseString((String)customNameString)).isJsonObject() && (jsonObject = jsonElement.getAsJsonObject()).has(TEXT_TAG)) {
                    return jsonObject.get(TEXT_TAG).getAsString();
                }
            }
            catch (Exception e) {
                log.debug("Could not parse CustomName as legacy JSON format", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean spawnAtPosition(BlockPos blockPos, ItemStack itemStack, Level level) {
        if (level.isClientSide) {
            return false;
        }
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || !presetData.hasEntityType() || !presetData.hasData()) {
            log.error("No valid preset data found in {}!", (Object)itemStack);
            return false;
        }
        EntityType<?> entityType = presetData.entityType();
        Entity entity = entityType.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (entity == null) {
            log.error("Unable to create entity for {} in {}", entityType, (Object)level);
            return false;
        }
        CompoundTag entityData = presetData.data();
        if (entityData.contains("UUID")) {
            entityData.remove("UUID");
        }
        entity.load(entityData);
        Component legacyCustomName = CompoundTagUtils.parseLegacyCustomName(entityData, (HolderLookup.Provider)level.registryAccess());
        if (legacyCustomName != null) {
            entity.setCustomName(legacyCustomName);
        }
        entity.snapTo((double)((float)blockPos.getX() + 0.5f), (double)blockPos.getY(), (double)((float)blockPos.getZ() + 0.5f));
        if (level.addFreshEntity(entity)) {
            UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
            log.debug("Spawned {} at {} with preset UUID {} and {} in {}", entityType, (Object)blockPos, (Object)presetUUID, (Object)entityData, (Object)level);
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = useOnContext.getItemInHand();
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null || !presetData.hasEntityType() || !presetData.hasData()) {
            log.warn("No valid preset found in {}!", (Object)itemStack);
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = useOnContext.getClickedPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            BaseSpawner baseSpawner = spawnerBlockEntity.getSpawner();
            SpawnData spawnData = new SpawnData(presetData.data(), Optional.empty(), Optional.empty());
            log.debug("Set spawn data {} for spawner {} at {}", (Object)spawnData, (Object)spawnerBlockEntity, (Object)blockPos);
            if (!SpawnerUtils.setNextSpawnData(baseSpawner, (LevelAccessor)level, blockPos, spawnData)) {
                return InteractionResult.FAIL;
            }
            spawnerBlockEntity.setChanged();
            itemStack.shrink(1);
            return InteractionResult.CONSUME;
        }
        if (blockEntity instanceof EasyNPCSpawnerBlockEntity) {
            EasyNPCSpawnerBlockEntity easyNPCSpawnerBlockEntity = (EasyNPCSpawnerBlockEntity)blockEntity;
            BaseEasyNPCSpawner baseEasyNPCSpawner = easyNPCSpawnerBlockEntity.getSpawner();
            SpawnData spawnData = new SpawnData(presetData.data(), Optional.empty(), Optional.empty());
            log.debug("Set spawn data {} for base NPC spawner {} at {}", (Object)spawnData, (Object)easyNPCSpawnerBlockEntity, (Object)blockPos);
            baseEasyNPCSpawner.setNextSpawnData(level, blockPos, spawnData);
            easyNPCSpawnerBlockEntity.setChanged();
            itemStack.shrink(1);
            return InteractionResult.CONSUME;
        }
        Iterable possibleSpawnPositions = BlockPos.spiralAround((BlockPos)useOnContext.getClickedPos(), (int)4, (Direction)Direction.NORTH, (Direction)Direction.EAST);
        for (BlockPos.MutableBlockPos possibleSpawnPosition : possibleSpawnPositions) {
            AABB aabb = new AABB((BlockPos)possibleSpawnPosition).inflate(0.1);
            BlockPos targetBlockPos = new BlockPos(possibleSpawnPosition.getX(), possibleSpawnPosition.getY() + 1, possibleSpawnPosition.getZ());
            if (!level.getBlockState(targetBlockPos.above()).isAir() || !level.getEntitiesOfClass(Entity.class, aabb).isEmpty() || !EasyNPCPresetItem.spawnAtPosition(targetBlockPos, itemStack, level)) continue;
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canDestroyBlock(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, LivingEntity livingEntity) {
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        PresetData presetData = PresetData.get(itemStack);
        if (presetData == null) {
            return;
        }
        UUID presetUUID = EasyNPCPresetItem.getPresetUUID(itemStack);
        if (presetUUID != null) {
            consumer.accept((Component)TextComponent.getText(presetUUID.toString()).withStyle(ChatFormatting.GRAY));
        }
        consumer.accept((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset").withStyle(ChatFormatting.GREEN));
        EntityType<?> entityType = presetData.entityType();
        if (entityType != null) {
            String customName = EasyNPCPresetItem.getCustomName(itemStack);
            if (customName != null) {
                consumer.accept((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.custom_name", customName).withStyle(ChatFormatting.GRAY));
            }
            consumer.accept((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_preset.entity_type", entityType.getDescription()).withStyle(ChatFormatting.GRAY));
        }
    }
}

