/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.trading;

import de.markusbordihn.easynpc.data.trading.TradingType;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class TradingDataSet {
    public static final String DATA_TRADING_DATA_SET_TAG = "TradingDataSet";
    public static final String DATA_TRADING_MAX_USES_TAG = "MaxUses";
    public static final String DATA_TRADING_REWARDED_XP_TAG = "RewardedXP";
    public static final String DATA_TRADING_RESETS_EVERY_MIN_TAG = "ResetsEveryMin";
    public static final String DATA_TRADING_LAST_RESET_TAG = "LastReset";
    public static final String DATA_TYPE_TAG = "Type";
    public static final class_9139<class_9129, TradingDataSet> STREAM_CODEC = new class_9139<class_9129, TradingDataSet>(){

        public TradingDataSet decode(class_9129 registryFriendlyByteBuf) {
            return new TradingDataSet(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, TradingDataSet tradingDataSet) {
            registryFriendlyByteBuf.method_10794((class_2520)tradingDataSet.createTag());
        }
    };
    private TradingType tradingType = TradingType.NONE;
    private int maxUses = 64;
    private int rewardedXP = 0;
    private int resetsEveryMin = 0;
    private long lastReset = 0L;

    public TradingDataSet() {
    }

    public TradingDataSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public TradingType getType() {
        return this.tradingType;
    }

    public void setType(TradingType tradingType) {
        this.tradingType = tradingType;
    }

    public boolean isType(TradingType tradingType) {
        return tradingType != null && this.tradingType == tradingType;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public int getRewardedXP() {
        return this.rewardedXP;
    }

    public void setRewardedXP(int rewardedXP) {
        this.rewardedXP = rewardedXP;
    }

    public int getResetsEveryMin() {
        return this.resetsEveryMin;
    }

    public void setResetsEveryMin(int resetsEveryMin) {
        this.resetsEveryMin = resetsEveryMin;
    }

    public long getLastReset() {
        return this.lastReset;
    }

    public void setLastReset(long lastReset) {
        this.lastReset = lastReset;
    }

    public void load(class_2487 compoundTag) {
        if (compoundTag == null || !compoundTag.method_10545(DATA_TRADING_DATA_SET_TAG)) {
            return;
        }
        class_2487 tradingData = compoundTag.method_68568(DATA_TRADING_DATA_SET_TAG);
        this.maxUses = tradingData.method_10550(DATA_TRADING_MAX_USES_TAG).orElse(64);
        this.rewardedXP = tradingData.method_10550(DATA_TRADING_REWARDED_XP_TAG).orElse(0);
        this.resetsEveryMin = tradingData.method_10550(DATA_TRADING_RESETS_EVERY_MIN_TAG).orElse(0);
        this.lastReset = tradingData.method_10545(DATA_TRADING_LAST_RESET_TAG) ? tradingData.method_10537(DATA_TRADING_LAST_RESET_TAG).orElse(System.currentTimeMillis()) : System.currentTimeMillis();
        this.tradingType = TradingType.valueOf(tradingData.method_10558(DATA_TYPE_TAG).orElse(""));
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2487 tradingData = new class_2487();
        tradingData.method_10569(DATA_TRADING_MAX_USES_TAG, this.maxUses);
        tradingData.method_10569(DATA_TRADING_REWARDED_XP_TAG, this.rewardedXP);
        tradingData.method_10569(DATA_TRADING_RESETS_EVERY_MIN_TAG, this.resetsEveryMin);
        tradingData.method_10544(DATA_TRADING_LAST_RESET_TAG, this.lastReset);
        tradingData.method_10582(DATA_TYPE_TAG, this.tradingType.name());
        compoundTag.method_10566(DATA_TRADING_DATA_SET_TAG, (class_2520)tradingData);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }
}

