/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item;

import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.item.EasyNPCSpawnerBlockItem;
import de.markusbordihn.easynpc.item.ModSpawnEggItem;
import de.markusbordihn.easynpc.item.attack.BulletItem;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetEmptyItem;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.item.configuration.MoveEasyNPCItem;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModItems {
    public static final Map<ModNPCEntityType, class_1792> NPC_SPAWN_EGGS = new EnumMap<ModNPCEntityType, class_1792>(ModNPCEntityType.class);
    public static final Map<ModCustomEntityType, class_1792> CUSTOM_NPC_SPAWN_EGGS = new EnumMap<ModCustomEntityType, class_1792>(ModCustomEntityType.class);
    public static final class_1792 BULLET_ITEM = new BulletItem(new class_1792.class_1793());
    public static final class_1792 EASY_NPC_PRESET_EMPTY_ITEM = new EasyNPCPresetEmptyItem(new class_1792.class_1793());
    public static final class_1792 EASY_NPC_PRESET_ITEM = new EasyNPCPresetItem(new class_1792.class_1793());
    public static final class_1792 EASY_NPC_SPAWNER_BOSS = new EasyNPCSpawnerBlockItem(ModBlocks.EASY_NPC_SPAWNER_BOSS, new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_npc", (String)SpawnerType.BOSS_SPAWNER.getId()))), SpawnerType.BOSS_SPAWNER);
    public static final class_1792 EASY_NPC_SPAWNER_DEFAULT = new EasyNPCSpawnerBlockItem(ModBlocks.EASY_NPC_SPAWNER_DEFAULT, new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_npc", (String)SpawnerType.DEFAULT_SPAWNER.getId()))), SpawnerType.DEFAULT_SPAWNER);
    public static final class_1792 EASY_NPC_SPAWNER_GROUP = new EasyNPCSpawnerBlockItem(ModBlocks.EASY_NPC_SPAWNER_GROUP, new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_npc", (String)SpawnerType.GROUP_SPAWNER.getId()))), SpawnerType.GROUP_SPAWNER);
    public static final class_1792 EASY_NPC_SPAWNER_SINGLE = new EasyNPCSpawnerBlockItem(ModBlocks.EASY_NPC_SPAWNER_SINGLE, new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_npc", (String)SpawnerType.SINGLE_SPAWNER.getId()))), SpawnerType.SINGLE_SPAWNER);
    public static final class_1792 MOVE_EASY_NPC = new MoveEasyNPCItem(new class_1792.class_1793());
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ModItems() {
    }

    public static void registerModItems() {
        class_1299<?> entityTypeObject;
        log.info("{} Configuration Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModItems.registerItem("move_easy_npc", MOVE_EASY_NPC);
        ModItems.registerItem("easy_npc_preset", EASY_NPC_PRESET_ITEM);
        ModItems.registerItem("easy_npc_preset_empty", EASY_NPC_PRESET_EMPTY_ITEM);
        log.info("{} Block Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModItems.registerItem(SpawnerType.BOSS_SPAWNER.getId(), EASY_NPC_SPAWNER_BOSS);
        ModItems.registerItem(SpawnerType.DEFAULT_SPAWNER.getId(), EASY_NPC_SPAWNER_DEFAULT);
        ModItems.registerItem(SpawnerType.GROUP_SPAWNER.getId(), EASY_NPC_SPAWNER_GROUP);
        ModItems.registerItem(SpawnerType.SINGLE_SPAWNER.getId(), EASY_NPC_SPAWNER_SINGLE);
        log.info("{} Weapon Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModItems.registerItem("bullet", BULLET_ITEM);
        log.info("{} Spawn Egg Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        for (ModNPCEntityType modNPCEntityType : ModNPCEntityType.values()) {
            entityTypeObject = ModEntityType.NPC_TYPE.get(modNPCEntityType);
            if (entityTypeObject == null) {
                log.error("Unable to register NPC spawn egg with id {}.", (Object)modNPCEntityType.getId());
                continue;
            }
            log.info("Registering NPC spawn egg for {} with id {}.", entityTypeObject, (Object)modNPCEntityType.getId());
            NPC_SPAWN_EGGS.put(modNPCEntityType, ModItems.registerSpawnEgg(modNPCEntityType.getId(), entityTypeObject));
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            entityTypeObject = ModEntityType.CUSTOM_TYPE.get(enum_);
            if (entityTypeObject == null) {
                log.error("Unable to register custom spawn egg with id {}.", (Object)((ModCustomEntityType)enum_).getId());
                continue;
            }
            log.info("Registering custom spawn egg for {} with id {}.", entityTypeObject, (Object)((ModCustomEntityType)enum_).getId());
            CUSTOM_NPC_SPAWN_EGGS.put((ModCustomEntityType)enum_, ModItems.registerSpawnEgg(((ModCustomEntityType)enum_).getId(), entityTypeObject));
        }
    }

    private static class_1792 registerItem(String id, class_1792 item) {
        return (class_1792)class_2378.method_10226((class_2378)class_7923.field_41178, (String)("easy_npc:" + id), (Object)item);
    }

    private static class_1792 registerSpawnEgg(String id, class_1299<?> entityType) {
        String spawnEggId = id + "_spawn_egg";
        return ModItems.registerItem(spawnEggId, (class_1792)new ModSpawnEggItem(entityType, new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_npc", (String)spawnEggId))).method_7894(class_1814.field_8904)));
    }
}

