/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import java.lang.reflect.Method;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static boolean setNextSpawnData(class_1917 spawner, class_1936 level, class_2338 blockPos, class_1952 spawnData) {
        try {
            Method method = SpawnerUtils.findSetNextSpawnDataMethod();
            method.invoke((Object)spawner, level, blockPos, spawnData);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to call setNextSpawnData for {} at {} with {}", (Object)spawner, (Object)blockPos, (Object)spawnData, (Object)e);
            return false;
        }
    }

    private static Method findSetNextSpawnDataMethod() {
        for (Method method : class_1917.class.getDeclaredMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 3 || !class_1936.class.isAssignableFrom(params[0]) || !class_2338.class.isAssignableFrom(params[1]) || !class_1952.class.isAssignableFrom(params[2])) continue;
            method.setAccessible(true);
            return method;
        }
        log.error("Could not find method setNextSpawnData(LevelAccessor, BlockPos, SpawnData)");
        return null;
    }
}

