/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface ModelVisibilityDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_MODEL_VISIBLE_TAG = "Visible";
    public static final class_9139<class_9129, Map<ModelPartType, Boolean>> MODEL_PART_VISIBILITY_STREAM_CODEC = new class_9139<class_9129, Map<ModelPartType, Boolean>>(){

        public Map<ModelPartType, Boolean> decode(class_9129 registryFriendlyByteBuf) {
            class_2487 compoundTag = registryFriendlyByteBuf.method_10798();
            EnumMap<ModelPartType, Boolean> modelPartMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
            for (String key : compoundTag.method_10541()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, compoundTag.method_10577(key).orElse(false));
            }
            return modelPartMap;
        }

        public void encode(class_9129 registryFriendlyByteBuf, Map<ModelPartType, Boolean> modelPartMap) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry<ModelPartType, Boolean> entry : modelPartMap.entrySet()) {
                compoundTag.method_10556(entry.getKey().getTagName(), entry.getValue().booleanValue());
            }
            registryFriendlyByteBuf.method_10794((class_2520)compoundTag);
        }
    };

    public static void registerSyncedModelVisibilityData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("Registering Synched Model Visibility Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_VISIBILITY, class_2945.method_12791(entityClass, EntityDataSerializersManager.MODEL_PART_VISIBILITY));
    }

    default public EnumMap<ModelPartType, Boolean> getModelPartVisibility() {
        EnumMap<ModelPartType, Boolean> modelPartMap = (EnumMap<ModelPartType, Boolean>)this.getSynchedEntityData(SynchedDataIndex.MODEL_VISIBILITY);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
            this.setModelPartVisibility(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartVisibility(EnumMap<ModelPartType, Boolean> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_VISIBILITY, modelPartMap, true);
        }
    }

    default public void setModelPartVisibility(ModelPartType modelPartType, boolean visible) {
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, visible);
            this.setModelPartVisibility(new EnumMap<ModelPartType, Boolean>(modelPartMap));
        }
    }

    default public boolean getModelPartVisibility(class_1304 equipmentSlot) {
        switch (equipmentSlot) {
            case field_6169: {
                return this.getModelPartVisibility(ModelPartType.HELMET);
            }
            case field_6174: {
                return this.getModelPartVisibility(ModelPartType.CHESTPLATE);
            }
            case field_6172: {
                return this.getModelPartVisibility(ModelPartType.LEGGINGS);
            }
            case field_6166: {
                return this.getModelPartVisibility(ModelPartType.BOOTS);
            }
        }
        return false;
    }

    default public boolean getModelPartVisibility(ModelPartType modelPartType) {
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        return modelPartMap.getOrDefault((Object)modelPartType, true);
    }

    default public void setModelPartVisibility(class_1304 equipmentSlot, boolean visible) {
        switch (equipmentSlot) {
            case field_6169: {
                this.setModelPartVisibility(ModelPartType.HELMET, visible);
                break;
            }
            case field_6174: {
                this.setModelPartVisibility(ModelPartType.CHESTPLATE, visible);
                break;
            }
            case field_6172: {
                this.setModelPartVisibility(ModelPartType.LEGGINGS, visible);
                break;
            }
            case field_6166: {
                this.setModelPartVisibility(ModelPartType.BOOTS, visible);
                break;
            }
        }
    }

    default public boolean hasChangedModelVisibility() {
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        for (Map.Entry<ModelPartType, Boolean> entry : modelPartMap.entrySet()) {
            if (entry.getValue() == null) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelVisibilityData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_VISIBILITY, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelVisibilityData(class_2487 compoundTag) {
        class_2487 visibilityTag = new class_2487();
        EnumMap<ModelPartType, Boolean> modelPartMap = this.getModelPartVisibility();
        for (Map.Entry<ModelPartType, Boolean> entry : modelPartMap.entrySet()) {
            visibilityTag.method_10556(entry.getKey().getTagName(), entry.getValue().booleanValue());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_VISIBLE_TAG, (class_2520)visibilityTag);
    }

    default public void readAdditionalModelVisibilityData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_VISIBLE_TAG)) {
            return;
        }
        class_2487 visibilityTag = compoundTag.method_68568(EASY_NPC_DATA_MODEL_VISIBLE_TAG);
        EnumMap<ModelPartType, Boolean> modelPartMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
        for (String key : visibilityTag.method_10541()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, visibilityTag.method_10577(key).orElse(false));
        }
        this.setModelPartVisibility(modelPartMap);
    }
}

