/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_4050;
import net.minecraft.class_7225;

public interface PresetDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final ServerDataAccessor<UUID> CUSTOM_DATA_PRESET_UUID = ServerEntityData.defineId(ServerDataIndex.PRESET_UUID, EntityDataSerializersManager.UUID);
    public static final String PRESET_UUID_TAG = "PresetUUID";
    public static final List<String> ENTITY_DATA_VOLATILE_FIELDS = List.of("AbsorptionAmount", "Air", "AngerTime", "DeathTime", "FallDistance", "FallFlying", "Fire", "forge:spawn_type", "HurtByTimestamp", "HurtTime", "Motion", "PortalCooldown");

    default public void importPresetData(class_2487 compoundTag) {
        if (compoundTag == null || compoundTag.method_33133() || this.getEntity() == null) {
            return;
        }
        if (this.getEntity() != null) {
            this.getEntity().method_18380(class_4050.field_18076);
        }
        if (this.getEasyNPCModelData() != null) {
            this.getEasyNPCModelData().setModelPose(ModelPose.DEFAULT);
        }
        if (this.getEasyNPCActionEventData() != null) {
            this.getEasyNPCActionEventData().clearActionEventSet();
        }
        if (this.getEasyNPCDialogData() != null) {
            this.getEasyNPCDialogData().clearDialogDataSet();
        }
        if (!compoundTag.method_10545("UUID") || !compoundTag.method_10545("Pos")) {
            class_2487 existingCompoundTag = this.serializePresetData();
            if (existingCompoundTag.method_10545("DialogData")) {
                existingCompoundTag.method_10551("DialogData");
            }
            if (existingCompoundTag.method_10545("ModelData")) {
                existingCompoundTag.method_10551("ModelData");
            }
            if (existingCompoundTag.method_10545("SkinData")) {
                existingCompoundTag.method_10551("SkinData");
            }
            if (existingCompoundTag.method_10545("RenderData")) {
                existingCompoundTag.method_10551("RenderData");
            }
            if (existingCompoundTag.method_10545("ActionData")) {
                existingCompoundTag.method_10551("ActionData");
            }
            log.debug("Merging preset {} with existing data {} for {}", (Object)compoundTag, (Object)existingCompoundTag, (Object)this);
            compoundTag = existingCompoundTag.method_10543(compoundTag);
        } else {
            log.debug("Importing full preset {} for {}", (Object)compoundTag, (Object)this);
        }
        this.getEntity().method_5651(compoundTag);
        class_2561 legacyCustomName = CompoundTagUtils.parseLegacyCustomName(compoundTag, (class_7225.class_7874)this.getEntity().method_56673());
        if (legacyCustomName != null) {
            this.getEntity().method_5665(legacyCustomName);
        }
    }

    default public class_2487 serializePresetData() {
        class_2487 compoundTag = new class_2487();
        if (this.getEntity() == null) {
            return compoundTag;
        }
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            compoundTag.method_10582("id", entityTypeId);
        }
        if (!compoundTag.method_10545(PRESET_UUID_TAG)) {
            CompoundTagUtils.writeUUID(compoundTag, PRESET_UUID_TAG, UUID.randomUUID());
        }
        class_2487 entityData = this.getEntity().method_5647(compoundTag);
        for (String entityDataFieldName : ENTITY_DATA_VOLATILE_FIELDS) {
            entityData.method_10551(entityDataFieldName);
        }
        return entityData;
    }

    default public boolean hasPresetUUID() {
        return this.getPresetUUID() != null;
    }

    default public UUID getPresetUUID() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_PRESET_UUID);
    }

    default public void setPresetUUID(UUID uuid) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_PRESET_UUID, uuid);
    }

    default public void defineCustomPresetData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_PRESET_UUID, null);
    }

    default public void addAdditionalPresetData(class_2487 compoundTag) {
        if (this.isServerSideInstance() && this.getPresetUUID() != null) {
            CompoundTagUtils.writeUUID(compoundTag, PRESET_UUID_TAG, this.getPresetUUID());
        }
    }

    default public void readAdditionalPresetData(class_2487 compoundTag) {
        UUID presetUUID = CompoundTagUtils.readUUID(compoundTag, PRESET_UUID_TAG);
        if (presetUUID != null) {
            this.setPresetUUID(presetUUID);
        }
    }
}

