/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7225;
import net.minecraft.class_9306;
import org.apache.logging.log4j.Logger;

public interface TradingDataCapable<E extends class_1314>
extends EasyNPC<E>,
class_1915 {
    public static final String DATA_OFFERS_TAG = "Offers";
    public static final String DATA_TRADING_DATA_TAG = "TradingData";

    public static void registerSyncedTradingData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Trading Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.TRADING_DATA_SET, class_2945.method_12791(entityClass, EntityDataSerializersManager.TRADING_DATA_SET));
        map.put(SynchedDataIndex.TRADING_INVENTORY, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13318));
        map.put(SynchedDataIndex.TRADING_MERCHANT_OFFERS, class_2945.method_12791(entityClass, EntityDataSerializersManager.MERCHANT_OFFERS));
    }

    private static class_9306 getItemCost(class_1799 itemStack) {
        return new class_9306((class_1935)(itemStack.method_7960() ? class_1799.field_8037.method_7909() : itemStack.method_7909()), itemStack.method_7947());
    }

    private static Optional<class_9306> getOptionalItemCost(class_1799 itemStack) {
        return itemStack.method_7960() ? Optional.empty() : Optional.of(TradingDataCapable.getItemCost(itemStack));
    }

    public class_1657 method_8257();

    public void method_8259(class_1657 var1);

    public class_1916 getMerchantTradingOffers();

    public void setMerchantTradingOffers(class_1916 var1);

    public void method_18008(class_1914 var1);

    public void method_19181();

    default public class_1916 method_8264() {
        if (this.getMerchantTradingOffers() == null) {
            this.updateMerchantTradingOffers();
        }
        return this.getMerchantTradingOffers();
    }

    default public void updateMerchantTradingOffers() {
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        class_1916 merchantOffers = new class_1916();
        if (tradingDataSet.isType(TradingType.BASIC) || tradingDataSet.isType(TradingType.ADVANCED) || tradingDataSet.isType(TradingType.CUSTOM)) {
            merchantOffers = this.getTradingOffers().method_53882();
        }
        if (!merchantOffers.isEmpty()) {
            merchantOffers.removeIf(merchantOffer -> merchantOffer.method_8246().method_7960() && merchantOffer.method_8247().method_7960() || merchantOffer.method_8250().method_7960());
        }
        this.setMerchantTradingOffers(merchantOffers);
    }

    default public void method_8261(class_1916 merchantOffers) {
    }

    default public int method_19269() {
        return 0;
    }

    default public void method_19271(int experience) {
    }

    default public boolean method_19270() {
        return true;
    }

    default public class_3414 method_18010() {
        return class_3417.field_14815;
    }

    @Override
    default public boolean isClientSideInstance() {
        return this.getEntityLevel() != null && this.getEntityLevel().method_8608();
    }

    default public void resetTradingOffers() {
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        log.debug("Reset trading offers {} for {}", (Object)merchantOffers, (Object)this);
        for (class_1914 merchantOffer : merchantOffers) {
            merchantOffer.method_19275();
        }
        this.setTradingOffers(merchantOffers);
        this.getTradingDataSet().setLastReset(System.currentTimeMillis());
    }

    default public class_1916 getTradingOffers() {
        return (class_1916)this.getSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS);
    }

    default public void setTradingOffers(class_1916 merchantOffers) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new class_1916());
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, merchantOffers);
        this.updateMerchantTradingOffers();
    }

    default public void method_8262(class_1914 merchantOffer) {
        merchantOffer.method_8244();
        this.getMob().field_6191 = -this.getMob().method_5970();
        this.method_18008(merchantOffer);
        class_1657 class_16572 = this.method_8257();
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            log.debug("Trade {} with {} for {}", (Object)merchantOffer, (Object)serverPlayer, (Object)this);
        }
    }

    default public void method_8258(class_1799 itemStack) {
        if (!this.isClientSideInstance() && this.getMob().field_6191 > -this.getMob().method_5970() + 20) {
            this.getMob().field_6191 = -this.getMob().method_5970();
            SoundDataCapable soundData = this.getEasyNPCSoundData();
            soundData.playDefaultTradeUpdatedSound(!itemStack.method_7960());
        }
    }

    default public void rewardMerchantTradeXp(class_1914 merchantOffer) {
        if (merchantOffer.method_8256() && merchantOffer.method_19279() > 0) {
            class_1309 livingEntity = this.getLivingEntity();
            int tradeExperience = 3 + livingEntity.method_59922().method_43048(merchantOffer.method_19279());
            livingEntity.method_37908().method_8649((class_1297)new class_1303(livingEntity.method_37908(), livingEntity.method_23317(), livingEntity.method_23318() + 0.5, livingEntity.method_23321(), tradeExperience));
        }
    }

    default public boolean hasTradingData() {
        TradingType tradingType = this.getTradingDataSet().getType();
        return (tradingType == TradingType.BASIC || tradingType == TradingType.ADVANCED) && this.getTradingOffers() != null && !this.getTradingOffers().isEmpty() || tradingType == TradingType.CUSTOM;
    }

    default public void stopMerchantTrading() {
        class_1915 merchant = this.getMerchant();
        if (merchant != null) {
            merchant.method_8259(null);
        }
    }

    default public TradingDataSet getTradingDataSet() {
        return (TradingDataSet)this.getSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET);
    }

    default public void setTradingDataSet(TradingDataSet tradingDataSet) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET, tradingDataSet);
    }

    default public void updateTradingDataSet() {
        TradingDataSet currentTradingDataSet = this.getTradingDataSet();
        this.setTradingDataSet(new TradingDataSet());
        this.setTradingDataSet(currentTradingDataSet);
    }

    default public boolean isValidTradingOffer(class_1799 itemA, class_1799 itemB, class_1799 itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.method_7960() || itemB != null && !itemB.method_7960()) && !itemResult.method_7960();
    }

    default public void openTradingScreen(class_3222 serverPlayer) {
        if (this.isClientSideInstance()) {
            return;
        }
        class_1915 merchant = this.getMerchant();
        if (merchant == null) {
            log.error("No merchant found for {} with {} from {}", (Object)this, (Object)this.getTradingOffers(), (Object)serverPlayer);
            return;
        }
        class_1916 merchantOffers = merchant.method_8264();
        if (merchantOffers.isEmpty()) {
            log.error("No trading offers found for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
            return;
        }
        if (merchant.method_8257() != null && merchant.method_8257() != serverPlayer) {
            log.warn("Unable to open trading screen for {} with {} from {}, {} is still trading.", (Object)this, (Object)merchantOffers, (Object)serverPlayer, (Object)merchant.method_8257());
            serverPlayer.method_7346();
            serverPlayer.method_64398((class_2561)TextComponent.getTranslatedText("trading.busy", this.getLivingEntity(), merchant.method_8257()));
            return;
        }
        if (this.getTradingDataSet().getResetsEveryMin() > 0) {
            long currentTime = System.currentTimeMillis();
            long resetTimeInMillis = (long)this.getTradingDataSet().getResetsEveryMin() * 60L * 1000L;
            if (currentTime - this.getTradingDataSet().getLastReset() > resetTimeInMillis) {
                this.resetTradingOffers();
            }
        }
        log.debug("Open trading screen for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
        merchant.method_8259((class_1657)serverPlayer);
        merchant.method_17449((class_1657)serverPlayer, (class_2561)(this.getEntity().method_5797() != null ? this.getEntity().method_5797() : TextComponent.getTranslatedText("trading")), 140);
    }

    default public boolean method_65125(class_1657 player) {
        class_1297 entity = this.getEntity();
        return entity.method_5805() && player.method_5858(entity) <= 64.0;
    }

    default public void defineSynchedTradingData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.TRADING_DATA_SET, new TradingDataSet());
        this.defineSynchedEntityData(builder, SynchedDataIndex.TRADING_INVENTORY, new class_2487());
        this.defineSynchedEntityData(builder, SynchedDataIndex.TRADING_MERCHANT_OFFERS, new class_1916());
    }

    default public void addAdditionalTradingData(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2487 tradingDataTag = new class_2487();
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        if (tradingDataSet != null) {
            tradingDataSet.save(tradingDataTag);
        }
        compoundTag.method_10566(DATA_TRADING_DATA_TAG, (class_2520)tradingDataTag);
        class_1916 merchantOffers = this.getTradingOffers();
        if (merchantOffers != null && !merchantOffers.isEmpty()) {
            compoundTag.method_10566(DATA_OFFERS_TAG, (class_2520)class_1916.field_48850.encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)merchantOffers).getOrThrow());
        }
    }

    default public void readAdditionalTradingData(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2487 tradingDataTag = compoundTag.method_68568(DATA_TRADING_DATA_TAG);
        if (tradingDataTag.method_10545("TradingDataSet")) {
            TradingDataSet tradingDataSet = new TradingDataSet(tradingDataTag);
            this.setTradingDataSet(tradingDataSet);
        }
        if (!compoundTag.method_10545(DATA_OFFERS_TAG)) {
            return;
        }
        DataResult dataResult = class_1916.field_48850.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag.method_10580(DATA_OFFERS_TAG));
        dataResult.resultOrPartial(class_156.method_29188((String)"Failed to load offers: ", arg_0 -> ((Logger)log).warn(arg_0))).ifPresent(this::setTradingOffers);
    }
}

