/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModEntityTypeProvider;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.entity.ModRawEntityType;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_7923;
import net.minecraft.class_8242;

public class TestCommand
extends Command {
    private TestCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"test").requires(commandSource -> commandSource.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"raw_npc").executes(context -> TestCommand.spawnAllEntities((class_2168)context.getSource(), ModRawEntityType.class))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModRawEntityType type : ModRawEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModRawEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModRawEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((class_2168)context.getSource(), type);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"standard_npc").executes(context -> TestCommand.spawnAllEntities((class_2168)context.getSource(), ModNPCEntityType.class))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModNPCEntityType type : ModNPCEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModNPCEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModNPCEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((class_2168)context.getSource(), type);
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"custom_npc").executes(context -> TestCommand.spawnAllEntities((class_2168)context.getSource(), ModCustomEntityType.class))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModCustomEntityType type : ModCustomEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModCustomEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModCustomEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((class_2168)context.getSource(), type);
        }))));
    }

    public static <T extends Enum<T>> int spawnAllEntities(class_2168 source, Class<T> enumClass) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3218 level = player.method_51469();
        class_2338 basePos = player.method_24515().method_10069(0, 1, 0);
        int index = 0;
        for (Enum type : (Enum[])enumClass.getEnumConstants()) {
            int xOffset = index % 5 * 10;
            int zOffset = index / 5 * 10;
            class_2338 npcPos = basePos.method_10069(xOffset, 0, zOffset);
            class_1299 entityType = (class_1299)class_7923.field_41177.method_29107(((ModEntityTypeProvider)((Object)type)).getResourceKey());
            TestCommand.spawnNpcInTestArea(level, npcPos, entityType);
            ++index;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Spawned " + ((Enum[])enumClass.getEnumConstants()).length + " " + enumClass.getSimpleName() + "s for testing.")), false);
        return 1;
    }

    public static <T extends Enum<T>> int spawnSingleEntity(class_2168 source, T type) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3218 level = player.method_51469();
        class_2338 basePos = player.method_24515().method_10069(0, 1, 0);
        class_1299 entityType = (class_1299)class_7923.field_41177.method_29107(((ModEntityTypeProvider)((Object)type)).getResourceKey());
        TestCommand.spawnNpcInTestArea(level, basePos, entityType);
        source.method_9226(() -> class_2561.method_43470((String)("Spawned " + type.getClass().getSimpleName() + ": " + type.name())), false);
        return 1;
    }

    private static void spawnNpcInTestArea(class_3218 level, class_2338 centerPos, class_1299<?> entityType) {
        int dz;
        int dx;
        int radius = 3;
        TestCommand.fillArea(level, centerPos.method_10069(-radius, -1, -radius), centerPos.method_10069(radius, 4, radius), class_2246.field_10124.method_9564());
        for (dx = -radius; dx <= radius; ++dx) {
            for (dz = -radius; dz <= radius; ++dz) {
                class_2338 floorPos = centerPos.method_10069(dx, -1, dz);
                if (Math.abs(dx) == radius && Math.abs(dz) == radius) {
                    level.method_8501(floorPos, class_2246.field_10171.method_9564());
                    continue;
                }
                level.method_8501(floorPos, class_2246.field_10153.method_9564());
            }
        }
        for (dx = -radius; dx <= radius; ++dx) {
            for (dz = -radius; dz <= radius; ++dz) {
                boolean isCorner;
                boolean isEdge = Math.abs(dx) == radius || Math.abs(dz) == radius;
                boolean bl = isCorner = Math.abs(dx) == radius && Math.abs(dz) == radius;
                if (!isEdge) continue;
                for (int dy = 0; dy < (isCorner ? 3 : 1); ++dy) {
                    class_2338 wallPos = centerPos.method_10069(dx, dy, dz);
                    level.method_8501(wallPos, class_2246.field_10620.method_9564());
                }
            }
        }
        TestCommand.fillArea(level, centerPos.method_10069(-radius, 3, -radius), centerPos.method_10069(radius, 3, radius), class_2246.field_10119.method_9564());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                class_2338 lowerSlabPos = centerPos.method_10069(dx, 3, dz);
                level.method_8501(lowerSlabPos, class_2246.field_10161.method_9564());
            }
        }
        class_2338 gatePos = centerPos.method_10069(0, 0, radius);
        level.method_8501(gatePos, (class_2680)class_2246.field_10188.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)class_2350.field_11035));
        class_2338 signPos = centerPos.method_10069(0, 4, 0);
        level.method_8501(signPos, class_2246.field_10121.method_9564());
        class_2586 blockEntity = level.method_8321(signPos);
        if (blockEntity instanceof class_2625) {
            class_2625 sign = (class_2625)blockEntity;
            sign.method_49840(new class_8242().method_49857(0, (class_2561)class_2561.method_43470((String)"EntityType:")).method_49857(1, (class_2561)class_2561.method_43470((String)entityType.method_35050())), false);
            sign.method_5431();
        }
        entityType.method_5894(level, null, null, centerPos, class_3730.field_16462, true, false);
    }

    private static void fillArea(class_3218 level, class_2338 from, class_2338 to, class_2680 blockState) {
        class_2338.method_20437((class_2338)from, (class_2338)to).forEach(pos -> level.method_8501(pos.method_10062(), blockState));
    }
}

