/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundTagUtils {
    public static final String ID_PREFIX = "id_";
    public static final String X_TAG = "X";
    public static final String Y_TAG = "Y";
    public static final String Z_TAG = "Z";
    public static final String UUID_TAG = "UUID";
    public static final String CUSTOM_NAME_TAG = "CustomName";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private CompoundTagUtils() {
    }

    public static void writeUUID(class_2487 compoundTag, UUID uuid) {
        CompoundTagUtils.writeUUID(compoundTag, UUID_TAG, uuid);
    }

    public static void writeUUID(class_2487 compoundTag, String key, UUID uuid) {
        if (compoundTag == null || key == null || uuid == null) {
            return;
        }
        long mostSignificantBits = uuid.getMostSignificantBits();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        int[] uuidArray = new int[]{(int)(mostSignificantBits >> 32), (int)mostSignificantBits, (int)(leastSignificantBits >> 32), (int)leastSignificantBits};
        compoundTag.method_10566(key, (class_2520)new class_2495(uuidArray));
    }

    public static UUID readUUID(class_2487 compoundTag) {
        return CompoundTagUtils.readUUID(compoundTag, UUID_TAG);
    }

    public static UUID readUUID(class_2487 compoundTag, String key) {
        if (compoundTag == null || key == null || !compoundTag.method_10545(key)) {
            return null;
        }
        class_2520 tag = compoundTag.method_10580(key);
        if (!(tag instanceof class_2495)) {
            return null;
        }
        class_2495 intArrayTag = (class_2495)tag;
        int[] uuidArray = intArrayTag.method_10588();
        if (uuidArray.length != 4) {
            return null;
        }
        try {
            long mostSignificantBits = (long)uuidArray[0] << 32 | (long)uuidArray[1] & 0xFFFFFFFFL;
            long leastSignificantBits = (long)uuidArray[2] << 32 | (long)uuidArray[3] & 0xFFFFFFFFL;
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class_2487 writeBlockPos(class_2338 blockPos) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569(X_TAG, blockPos.method_10263());
        compoundTag.method_10569(Y_TAG, blockPos.method_10264());
        compoundTag.method_10569(Z_TAG, blockPos.method_10260());
        return compoundTag;
    }

    public static class_2338 readBlockPos(class_2487 compoundTag) {
        if (!(compoundTag != null && compoundTag.method_10545(X_TAG) && compoundTag.method_10545(Y_TAG) && compoundTag.method_10545(Z_TAG))) {
            return class_2338.field_10980;
        }
        return new class_2338(compoundTag.method_10550(X_TAG).orElse(0).intValue(), compoundTag.method_10550(Y_TAG).orElse(0).intValue(), compoundTag.method_10550(Z_TAG).orElse(0).intValue());
    }

    public static class_2487 writeScale(float x, float y, float z) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10548(X_TAG, x);
        compoundTag.method_10548(Y_TAG, y);
        compoundTag.method_10548(Z_TAG, z);
        return compoundTag;
    }

    public static class_2487 writeCustomScale(CustomScale customScale) {
        return CompoundTagUtils.writeScale(customScale.x(), customScale.y(), customScale.z());
    }

    public static CustomScale readCustomScale(class_2487 compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        return new CustomScale(compoundTag.method_10583(X_TAG).orElse(Float.valueOf(0.0f)).floatValue(), compoundTag.method_10583(Y_TAG).orElse(Float.valueOf(0.0f)).floatValue(), compoundTag.method_10583(Z_TAG).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public static class_2960 readResourceLocation(class_2487 compoundTag, String name) {
        if (compoundTag == null || !compoundTag.method_10545(name)) {
            return null;
        }
        String resourceLocationString = compoundTag.method_10558(name).orElse("");
        if (resourceLocationString.isEmpty()) {
            return null;
        }
        if (!resourceLocationString.contains(":")) {
            return class_2960.method_60655((String)"easy_npc", (String)resourceLocationString);
        }
        String namespace = compoundTag.method_10558(name).orElse("").split(":")[0];
        String path = compoundTag.method_10558(name).orElse("").split(":")[1];
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static class_2499 writeResourceLocations(Set<class_2960> resourceLocations) {
        class_2499 listTag = new class_2499();
        resourceLocations.forEach(resourceLocation -> {
            int hashCode = resourceLocation.hashCode();
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582(ID_PREFIX + hashCode, resourceLocation.toString());
            listTag.add((Object)compoundTag);
        });
        return listTag;
    }

    public static Set<class_2960> readResourceLocations(class_2499 listTag) {
        HashSet<class_2960> resourceLocations = new HashSet<class_2960>();
        listTag.forEach(tag -> {
            class_2487 compoundTag = (class_2487)tag;
            compoundTag.method_10541().forEach(key -> {
                if (key.startsWith(ID_PREFIX)) {
                    resourceLocations.add(CompoundTagUtils.readResourceLocation(compoundTag, key));
                }
            });
        });
        return resourceLocations;
    }

    public static class_2561 parseLegacyCustomName(class_2487 compoundTag, class_7225.class_7874 registryAccess) {
        if (compoundTag == null || !compoundTag.method_10545(CUSTOM_NAME_TAG)) {
            return null;
        }
        class_2520 customNameTag = compoundTag.method_10580(CUSTOM_NAME_TAG);
        if (customNameTag instanceof class_2519) {
            String jsonString = compoundTag.method_10558(CUSTOM_NAME_TAG).orElse("");
            if (jsonString.isEmpty()) {
                return null;
            }
            try {
                JsonElement jsonElement = JsonParser.parseString((String)jsonString);
                class_5250 component = class_2561.class_2562.method_10872((JsonElement)jsonElement, (class_7225.class_7874)registryAccess);
                if (component != null) {
                    log.debug("Parsed legacy CustomName format: {}", (Object)jsonString);
                    return component;
                }
            }
            catch (Exception e) {
                log.warn("Failed to parse legacy CustomName format: {}", (Object)jsonString, (Object)e);
            }
        }
        return null;
    }
}

