/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.dialog;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.Screen;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogScreenLayout;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class DialogScreen<T extends DialogMenu>
extends Screen<T> {
    private static final int BUTTON_WIDTH = 126;
    private static final int MIDDLE_BUTTON_WIDTH = 200;
    private static final int LARGE_BUTTON_WIDTH = 250;
    private static final int MAX_NUMBER_OF_PIXEL_PER_LINE = 180;
    private static final int MAX_NUMBER_OF_DIALOG_LINES = 10;
    private static DialogScreenLayout dialogScreenLayout = DialogScreenLayout.UNKNOWN;
    protected final ArrayList<Button> dialogButtons = new ArrayList();
    protected final Component dialogText;
    protected final DialogMetaData dialogMetaData;
    protected Button dialogForwardButton = null;
    protected Button dialogBackwardButton = null;
    protected String dialog;
    protected Component dialogComponent;
    protected int numberOfDialogLines = 1;
    protected int dialogPageIndex = 0;
    private List<FormattedCharSequence> cachedDialogComponents = Collections.emptyList();

    public DialogScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component, 280, 200);
        this.dialogText = this.getDialogText();
        this.dialogMetaData = new DialogMetaData(this.getEasyNPC().getLivingEntity(), (Player)(this.minecraftInstance != null ? this.minecraftInstance.player : null));
    }

    private static void setDialogScreenLayout(DialogScreenLayout dialogScreenLayout) {
        DialogScreen.dialogScreenLayout = dialogScreenLayout;
    }

    protected void renderDialog(GuiGraphics guiGraphics) {
        int dialogTopPosition = this.topPos + 20;
        switch (dialogScreenLayout) {
            case COMPACT_TEXT_ONLY: 
            case COMPACT_TEXT_WITH_ONE_BUTTON: 
            case COMPACT_TEXT_WITH_TWO_BUTTONS: 
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: 
            case COMPACT_TEXT_WITH_THREE_BUTTONS: 
            case COMPACT_TEXT_WITH_FOUR_BUTTONS: 
            case COMPACT_TEXT_WITH_FIVE_BUTTONS: 
            case COMPACT_TEXT_WITH_SIX_BUTTONS: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DIALOG, this.leftPos + 70, dialogTopPosition, 0, 120, 205, 78);
                break;
            }
            default: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DIALOG, this.leftPos + 70, dialogTopPosition, 0, 0, 205, 118);
            }
        }
        if (!this.cachedDialogComponents.isEmpty()) {
            for (int line = this.dialogPageIndex * 10; line < this.numberOfDialogLines && line < 10 * (this.dialogPageIndex + 1); ++line) {
                Objects.requireNonNull(this.font);
                int textTopPosition = dialogTopPosition + 6 + (line - this.dialogPageIndex * 10) * (9 + 2);
                FormattedCharSequence formattedCharSequence = this.cachedDialogComponents.get(line);
                Text.drawString(guiGraphics, this.font, formattedCharSequence, this.leftPos + 87, textTopPosition, 0);
            }
        }
    }

    private void setDialogText(DialogDataEntry dialogData) {
        if (dialogData == null) {
            return;
        }
        String dialogText = dialogData.getDialogText(this.dialogMetaData);
        if (dialogText == null || dialogText.isBlank()) {
            return;
        }
        this.dialogComponent = TextComponent.getText(dialogText);
        this.cachedDialogComponents = this.font.split((FormattedText)this.dialogComponent, 180);
        Objects.requireNonNull(this.font);
        this.numberOfDialogLines = Math.min(128 / 9, this.cachedDialogComponents.size());
    }

    private void addDialogButton(DialogButtonEntry dialogButtonEntry) {
        if (dialogButtonEntry == null) {
            return;
        }
        int dialogButtonMaxTextLength = switch (dialogScreenLayout) {
            case DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON, DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS, DialogScreenLayout.TEXT_WITH_ONE_BUTTON, DialogScreenLayout.TEXT_WITH_TWO_BUTTONS, DialogScreenLayout.TEXT_WITH_THREE_BUTTONS -> 41;
            case DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS -> 32;
            default -> 22;
        };
        TextButton dialogButton = new TextButton(this.leftPos + 70, this.topPos + 55, 198, dialogButtonEntry.getButtonName(dialogButtonMaxTextLength), onPress -> {
            if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_BUTTON_CLICK)) {
                NetworkMessageHandlerManager.getServerHandler().executeActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_BUTTON_CLICK);
            }
            if (dialogButtonEntry.hasActionData()) {
                UUID buttonId = dialogButtonEntry.id();
                NetworkMessageHandlerManager.getServerHandler().executeDialogButtonAction(this.getEasyNPCUUID(), this.getDialogUUID(), buttonId);
            } else {
                this.closeScreen();
            }
        });
        dialogButton.visible = dialogButtonEntry.name() != null && !dialogButtonEntry.name().isBlank();
        this.dialogButtons.add(dialogButton);
    }

    private Button renderDialogButton(int buttonIndex, int width, int left, int top) {
        Button dialogButton = this.dialogButtons.get(buttonIndex);
        dialogButton.setWidth(width);
        dialogButton.setX(left);
        dialogButton.setY(top);
        return (Button)this.addRenderableWidget((GuiEventListener)dialogButton);
    }

    private void renderDialogButtons() {
        switch (dialogScreenLayout) {
            case COMPACT_TEXT_ONLY: 
            case TEXT_ONLY: {
                break;
            }
            case COMPACT_TEXT_WITH_ONE_BUTTON: {
                this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 140);
                break;
            }
            case COMPACT_TEXT_WITH_TWO_BUTTONS: {
                Button firstCompactDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                this.renderDialogButton(1, 126, firstCompactDialogButton.getX() + firstCompactDialogButton.getWidth() + 10, firstCompactDialogButton.getY());
                break;
            }
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: {
                Button firstCompactLargeDialogButton = this.renderDialogButton(0, 200, this.leftPos + 75, this.topPos + 115);
                this.renderDialogButton(1, 200, firstCompactLargeDialogButton.getX(), firstCompactLargeDialogButton.getY() + firstCompactLargeDialogButton.getHeight() + 10);
                break;
            }
            case TEXT_WITH_ONE_BUTTON: {
                this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 170);
                break;
            }
            case TEXT_WITH_TWO_BUTTONS: {
                Button firstTwoDialogButton = this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 145);
                this.renderDialogButton(1, 250, firstTwoDialogButton.getX(), firstTwoDialogButton.getY() + firstTwoDialogButton.getHeight() + 10);
                break;
            }
            case COMPACT_TEXT_WITH_THREE_BUTTONS: 
            case TEXT_WITH_THREE_BUTTONS: {
                Button firstThreeDialogButton = this.renderDialogButton(0, 250, this.leftPos + 18, this.topPos + 140);
                Button secondThreeDialogButton = this.renderDialogButton(1, 250, firstThreeDialogButton.getX(), firstThreeDialogButton.getY() + firstThreeDialogButton.getHeight() + 5);
                this.renderDialogButton(2, 250, secondThreeDialogButton.getX(), secondThreeDialogButton.getY() + secondThreeDialogButton.getHeight() + 5);
                break;
            }
            case COMPACT_TEXT_WITH_FOUR_BUTTONS: 
            case TEXT_WITH_FOUR_BUTTONS: {
                Button firstFourDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 150);
                Button secondFourDialogButton = this.renderDialogButton(1, 126, firstFourDialogButton.getX() + firstFourDialogButton.getWidth() + 10, firstFourDialogButton.getY());
                Button thirdFourDialogButton = this.renderDialogButton(2, 126, firstFourDialogButton.getX(), firstFourDialogButton.getY() + firstFourDialogButton.getHeight() + 10);
                this.renderDialogButton(3, 126, secondFourDialogButton.getX(), thirdFourDialogButton.getY());
                break;
            }
            case COMPACT_TEXT_WITH_FIVE_BUTTONS: 
            case TEXT_WITH_FIVE_BUTTONS: {
                Button firstFiveDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                Button secondFiveDialogButton = this.renderDialogButton(1, 126, firstFiveDialogButton.getX() + firstFiveDialogButton.getWidth() + 10, firstFiveDialogButton.getY());
                Button thirdFiveDialogButton = this.renderDialogButton(2, 126, firstFiveDialogButton.getX(), firstFiveDialogButton.getY() + firstFiveDialogButton.getHeight() + 5);
                this.renderDialogButton(3, 126, secondFiveDialogButton.getX(), thirdFiveDialogButton.getY());
                this.renderDialogButton(4, 126, firstFiveDialogButton.getX(), thirdFiveDialogButton.getY() + thirdFiveDialogButton.getHeight() + 5);
                break;
            }
            case COMPACT_TEXT_WITH_SIX_BUTTONS: 
            case TEXT_WITH_SIX_BUTTONS: {
                Button firstSixDialogButton = this.renderDialogButton(0, 126, this.leftPos + 10, this.topPos + 140);
                Button secondSixDialogButton = this.renderDialogButton(1, 126, firstSixDialogButton.getX() + firstSixDialogButton.getWidth() + 10, firstSixDialogButton.getY());
                Button thirdSixDialogButton = this.renderDialogButton(2, 126, firstSixDialogButton.getX(), firstSixDialogButton.getY() + firstSixDialogButton.getHeight() + 5);
                this.renderDialogButton(3, 126, secondSixDialogButton.getX(), thirdSixDialogButton.getY());
                Button fifthSixDialogButton = this.renderDialogButton(4, 126, firstSixDialogButton.getX(), thirdSixDialogButton.getY() + thirdSixDialogButton.getHeight() + 5);
                this.renderDialogButton(5, 126, secondSixDialogButton.getX(), fifthSixDialogButton.getY());
                break;
            }
            default: {
                log.warn("Unknown dialog screen layout {} for {} with {} line(s)", (Object)dialogScreenLayout, (Object)this.getDialogDataSet(), (Object)this.numberOfDialogLines);
            }
        }
    }

    private void defineDialogNavigationButtons() {
        int dialogNavigationButtonTopPosition = dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_ONLY || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_ONE_BUTTON || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_TWO_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_THREE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_FOUR_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_FIVE_BUTTONS || dialogScreenLayout == DialogScreenLayout.COMPACT_TEXT_WITH_SIX_BUTTONS ? this.topPos + 95 : this.topPos + 136;
        this.dialogForwardButton = (Button)this.addRenderableWidget((GuiEventListener)new SpriteButton(this.leftPos + 257, dialogNavigationButtonTopPosition, 12, 12, Constants.TEXTURE_DIALOG, 206, 2, 12, 12, onPress -> {
            int n = this.dialogPageIndex = this.dialogPageIndex < this.numberOfDialogLines / 10 ? this.dialogPageIndex + 1 : 0;
            if (this.dialogBackwardButton != null) {
                boolean bl = this.dialogBackwardButton.active = this.dialogPageIndex > 0;
            }
            if (this.dialogForwardButton != null) {
                this.dialogForwardButton.active = this.dialogPageIndex < this.numberOfDialogLines / 10;
            }
        }));
        this.dialogForwardButton.active = this.dialogPageIndex < this.numberOfDialogLines / 10;
        this.dialogBackwardButton = (Button)this.addRenderableWidget((GuiEventListener)new SpriteButton(this.leftPos + 245, dialogNavigationButtonTopPosition, 12, 12, Constants.TEXTURE_DIALOG, 207, 28, 12, 12, onPress -> {
            int n = this.dialogPageIndex = this.dialogPageIndex > 0 ? this.dialogPageIndex - 1 : this.numberOfDialogLines / 10;
            if (this.dialogForwardButton != null) {
                boolean bl = this.dialogForwardButton.active = this.dialogPageIndex < this.numberOfDialogLines / 10;
            }
            if (this.dialogBackwardButton != null) {
                this.dialogBackwardButton.active = this.dialogPageIndex > 0;
            }
        }));
        this.dialogBackwardButton.active = this.dialogPageIndex > 0;
    }

    @Override
    public void init() {
        super.init();
        this.titleLabelX = 10;
        this.titleLabelY = 8;
        this.closeButton.setX(this.leftPos + this.imageWidth - 13);
        this.closeButton.setY(this.topPos + 4);
        DialogScreen.setDialogScreenLayout(DialogUtils.getDialogScreenLayout(this.getDialogData(), this.font));
        log.debug("Prepare Dialog Screen {} with page index {} for {} with {} line(s) and layout {}", (Object)this.getDialogUUID(), (Object)this.getPageIndex(), (Object)this.getDialogDataSet(), (Object)this.numberOfDialogLines, (Object)dialogScreenLayout);
        this.setDialogText(this.getDialogData());
        log.debug("Dialog with {} line(s) and layout {}", (Object)this.numberOfDialogLines, (Object)dialogScreenLayout);
        if (this.numberOfDialogLines > 10) {
            this.defineDialogNavigationButtons();
        }
        if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_OPEN_DIALOG)) {
            NetworkMessageHandlerManager.getServerHandler().executeActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_OPEN_DIALOG);
        }
        if (this.hasDialogData() && this.getDialogData().getNumberOfDialogButtons() > 0) {
            this.dialogButtons.ensureCapacity(this.getDialogData().getNumberOfDialogButtons());
            for (DialogButtonEntry dialogButtonEntry : this.getDialogData().getDialogButtons()) {
                if (dialogButtonEntry == null) continue;
                this.addDialogButton(dialogButtonEntry);
            }
            this.renderDialogButtons();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        if (this.getEasyNPC() == null) {
            return;
        }
        super.render(guiGraphics, x, y, partialTicks);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        EntityScreenRenderer.renderEntity(guiGraphics, this.getEasyNPC(), EntityRenderConfig.dialog(this.leftPos + 40, this.topPos + 140 + this.getEasyNPC().getEasyNPCDialogData().getEntityDialogTop(), this.getEasyNPC().getEasyNPCDialogData().getEntityDialogScaling(), Math.round((float)(this.leftPos - 100) - this.xMouse * 0.25f), Math.round((float)(this.topPos + 10 + this.getEasyNPC().getEasyNPCDialogData().getEntityDialogTop()) - this.yMouse * 0.5f)), this.xMouse, this.yMouse);
        guiGraphics.pose().popPose();
        this.renderDialog(guiGraphics);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        Text.drawString(guiGraphics, this.font, this.title, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        switch (dialogScreenLayout) {
            case UNKNOWN: {
                break;
            }
            case COMPACT_TEXT_ONLY: 
            case COMPACT_TEXT_WITH_ONE_BUTTON: 
            case COMPACT_TEXT_WITH_TWO_BUTTONS: 
            case COMPACT_TEXT_WITH_TWO_LARGE_BUTTONS: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 200, 170);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos, 165, 0, 85, 170);
                break;
            }
            default: {
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos, 0, 0, 210, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos, 165, 0, 85, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos, this.topPos + 70, 0, 30, 210, 140);
                Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, this.leftPos + 200, this.topPos + 70, 165, 30, 85, 140);
            }
        }
    }

    @Override
    public void onClose() {
        if (this.getActionEventSet().hasActionEvent(ActionEventType.ON_CLOSE_DIALOG)) {
            NetworkMessageHandlerManager.getServerHandler().executeActionEvent(this.getEasyNPCUUID(), ActionEventType.ON_CLOSE_DIALOG);
        }
        super.onClose();
    }
}

