/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ConditionDataSet {
    public static final ConditionDataSet EMPTY = new ConditionDataSet();
    public static final String CONDITION_DATA_SET_TAG = "ConditionDataSet";
    private final Set<ConditionDataEntry> conditionDataEntries = new LinkedHashSet<ConditionDataEntry>();

    public ConditionDataSet() {
    }

    public ConditionDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public boolean isEmpty() {
        return this.conditionDataEntries.isEmpty();
    }

    public int size() {
        return this.conditionDataEntries.size();
    }

    public void load(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.contains(CONDITION_DATA_SET_TAG)) {
            return;
        }
        CompoundTag conditionDataSetTag = compoundTag.getCompoundOrEmpty(CONDITION_DATA_SET_TAG);
        this.conditionDataEntries.clear();
        ListTag conditionDataEntriesTag = conditionDataSetTag.getListOrEmpty(CONDITION_DATA_SET_TAG);
        for (int i = 0; i < conditionDataEntriesTag.size(); ++i) {
            CompoundTag conditionDataEntryTag = conditionDataEntriesTag.getCompoundOrEmpty(i);
            ConditionDataEntry conditionDataEntry = new ConditionDataEntry(conditionDataEntryTag);
            this.conditionDataEntries.add(conditionDataEntry);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag conditionDataEntriesTag = new ListTag();
        for (ConditionDataEntry conditionDataEntry : this.conditionDataEntries) {
            if (conditionDataEntry == null) continue;
            conditionDataEntriesTag.add((Object)conditionDataEntry.createTag());
        }
        if (!conditionDataEntriesTag.isEmpty()) {
            compoundTag.put(CONDITION_DATA_SET_TAG, (Tag)conditionDataEntriesTag);
        }
        return compoundTag;
    }

    public String toString() {
        return this.conditionDataEntries.toString();
    }
}

