/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.raw;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.status.StatusDataType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.synched.SynchedEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.InteractionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.VisibilityHandler;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.server.player.FakePlayer;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CatRaw
extends Cat
implements EasyNPCBase<Cat> {
    public static final String ID = "cat_raw";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final EnumMap<SynchedDataIndex, EntityDataAccessor<?>> entityDataAccessorMap = new EnumMap(SynchedDataIndex.class);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private final EnumMap<TickerType, Integer> tickerMap = new EnumMap(TickerType.class);
    private final EnumMap<StatusDataType, Boolean> statusDataFlagMap = new EnumMap(StatusDataType.class);
    protected MerchantOffers merchantTradingOffers;
    private ServerEntityData serverEntityData;
    private int attackAnimationTick;
    private int npcDataVersion = -1;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private SynchedEntityData synchedEntityData;
    private Player tradingPlayer;
    private FakePlayer fakePlayer;

    public CatRaw(EntityType<? extends Cat> entityType, Level level, Enum<?> variant) {
        super(entityType, level);
        this.registerEasyNPCDefaultVariant(variant);
    }

    public CatRaw(EntityType<? extends Cat> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(this.fakePlayer)) {
            this.fakePlayer = new FakePlayer(level, blockPos);
            return this.fakePlayer;
        }
        return this.fakePlayer.updatePosition(level, blockPos);
    }

    @Override
    public int getTicker(TickerType tickerType) {
        return this.tickerMap.getOrDefault((Object)tickerType, 0);
    }

    @Override
    public void setTicker(TickerType tickerType, int ticker) {
        this.tickerMap.put(tickerType, ticker);
    }

    @Override
    public EnumMap<StatusDataType, Boolean> getStatusDataFlags() {
        return this.statusDataFlagMap;
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    @Override
    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(serverLevel, entity);
    }

    public void handleEntityEvent(byte flag) {
        super.handleEntityEvent(flag);
        if (flag == 4) {
            this.attackAnimationTick = 10;
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isClientSideInstance()) {
            this.updateSwingTime();
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
        } else {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public Component getName() {
        Component component = this.getCustomName();
        return component != null ? TextUtils.removeAction(component) : this.getTypeName();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damage) {
        this.handleHurtEvent(damageSource, damage);
        return super.hurtServer(serverLevel, damageSource, damage);
    }

    public void die(DamageSource damageSource) {
        this.handleDieEvent(damageSource);
        super.die(damageSource);
    }

    public Entity teleport(TeleportTransition teleportTransition) {
        this.handleChangeDimensionEvent(teleportTransition);
        return super.teleport(teleportTransition);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionHandler.handleMobInteraction(this, player, hand);
    }

    public boolean isClientSide() {
        return this.isClientSideInstance();
    }

    public boolean isInvisible() {
        return VisibilityHandler.handleIsInvisible(this, super.isInvisible());
    }

    public boolean isInvisibleTo(Player player) {
        return VisibilityHandler.handleIsInvisibleToPlayer(this, player, super.isInvisibleTo(player));
    }

    @Override
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(Player player) {
        this.tradingPlayer = player;
    }

    @Override
    public MerchantOffers getMerchantTradingOffers() {
        return this.merchantTradingOffers;
    }

    @Override
    public void setMerchantTradingOffers(MerchantOffers merchantOffers) {
        this.merchantTradingOffers = merchantOffers;
    }

    @Override
    public void rewardTradeXp(MerchantOffer merchantOffer) {
        this.rewardMerchantTradeXp(merchantOffer);
    }

    @Override
    public void stopTrading() {
        this.stopMerchantTrading();
    }

    @Override
    public int getNPCDataVersion() {
        return this.npcDataVersion;
    }

    @Override
    public void setNPCDataVersion(int version) {
        this.npcDataVersion = version;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, SpawnGroupData spawnGroupData) {
        AttributeHandler.handleDefaultAttributes((PathfinderMob)this);
        return this.finalizeEasyNPCSpawn(super.finalizeSpawn(serverLevelAccessor, difficulty, entitySpawnReason, spawnGroupData));
    }

    @Override
    public void handleEasyNPCJoinEvent(EasyNPC<?> easyNPC) {
        this.onEasyNPCJoinUpdateObjective(easyNPC);
    }

    @Override
    public void handleEasyNPCLeaveEvent(EasyNPC<?> easyNPC) {
        this.onEasyNPCLeaveUpdateObjective(easyNPC);
    }

    @Override
    public void handlePlayerJoinEvent(ServerPlayer serverPlayer) {
        this.onPlayerJoinUpdateObjective(serverPlayer);
    }

    @Override
    public void handlePlayerLeaveEvent(ServerPlayer serverPlayer) {
        this.onPlayerLeaveUpdateObjective(serverPlayer);
    }

    @Override
    public void handleLivingEntityJoinEvent(LivingEntity livingEntity) {
        this.onLivingEntityJoinUpdateObjective(livingEntity);
    }

    @Override
    public void handleLivingEntityLeaveEvent(LivingEntity livingEntity) {
        this.onLivingEntityLeaveUpdateObjective(livingEntity);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeaponItem) {
        return AttackHandler.canFireProjectileWeapon(projectileWeaponItem);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    public GoalSelector getEntityGoalSelector() {
        return this.goalSelector;
    }

    @Override
    public GoalSelector getEntityTargetSelector() {
        return this.targetSelector;
    }

    @Override
    public <T> void defineSynchedEntityData(SynchedEntityData.Builder builder, SynchedDataIndex synchedDataIndex, T defaultData) {
        if (this.synchedEntityData == null) {
            this.synchedEntityData = new SynchedEntityData((Entity)this, entityDataAccessorMap);
        }
        this.synchedEntityData.define(builder, synchedDataIndex, defaultData);
    }

    @Override
    public <T> void setSynchedEntityData(SynchedDataIndex synchedDataIndex, T data, boolean forceUpdate) {
        this.synchedEntityData.set(synchedDataIndex, data, forceUpdate);
    }

    @Override
    public <T> T getSynchedEntityData(SynchedDataIndex synchedDataIndex) {
        return this.synchedEntityData.get(synchedDataIndex);
    }

    @Override
    public void defineServerEntityData() {
        this.serverEntityData = new ServerEntityData((Entity)this);
    }

    @Override
    public ServerEntityData getServerEntityData() {
        if (this.serverEntityData == null) {
            this.defineServerEntityData();
        }
        return this.serverEntityData;
    }

    public boolean canBeLeashed() {
        return super.canBeLeashed() && this.getEntityAttributes().getInteractionAttributes().canBeLeashed();
    }

    public boolean isAttackable() {
        return this.getEntityAttributes().getCombatAttributes().isAttackableByPlayers();
    }

    public boolean isPushable() {
        return this.getEntityAttributes().getInteractionAttributes().isPushable();
    }

    protected void pushEntities() {
        if (this.getEntityAttributes().getInteractionAttributes().pushEntities()) {
            super.pushEntities();
        }
    }

    public boolean isInvulnerable() {
        return this.getEntityAttributes().getCombatAttributes().isInvulnerable();
    }

    public boolean isInvulnerableTo(ServerLevel serverLevel, DamageSource damageSource) {
        return AttackHandler.handleIsInvulnerableTo(this, damageSource, super.isInvulnerableTo(serverLevel, damageSource));
    }

    public void playAmbientSound() {
        this.playDefaultAmbientSound();
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public void playHurtSound(DamageSource damageSource) {
        this.playDefaultHurtSound(damageSource);
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playDefaultStepSound(blockPos, blockState);
    }

    public SoundEvent getDeathSound() {
        return this.getDefaultDeathSound();
    }

    protected void handlePortal() {
        if (this.getEntityAttributes().getMovementAttributes().canUseNetherPortal()) {
            super.handlePortal();
        }
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public void baseTick() {
        super.baseTick();
        if (this.isClientSideInstance() || !this.isAlive()) {
            return;
        }
        this.handleCustomObjectiveBaseTick();
        this.handleBaseTick();
    }

    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        super.travel(vec3);
    }

    public boolean isSaddled() {
        return false;
    }

    @Override
    public boolean supportsPoseConfiguration() {
        return true;
    }

    @Override
    public boolean supportsScalingConfiguration() {
        return true;
    }

    @Override
    public boolean supportsDefaultRotationConfiguration() {
        return true;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.CAT;
    }

    @Override
    public Enum<?>[] getVariantTypes() {
        return VariantType.values();
    }

    @Override
    public Enum<?> getDefaultVariantType() {
        return VariantType.BLACK;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.FELINE;
    }

    @Override
    public Enum<?> getVariantType(String name) {
        try {
            return VariantType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariantType();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.defineEasyNPCBaseSyncedData(builder);
        this.defineEasyNPCBaseServerSideData();
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.addPersistentAngerSaveData(compoundTag);
        this.addEasyNPCBaseAdditionalSaveData(compoundTag, (HolderLookup.Provider)this.registryAccess());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.readPersistentAngerSaveData(this.level(), compoundTag);
        this.readEasyNPCBaseAdditionalSaveData(compoundTag, (HolderLookup.Provider)this.registryAccess());
        Component legacyCustomName = CompoundTagUtils.parseLegacyCustomName(compoundTag, (HolderLookup.Provider)this.registryAccess());
        if (legacyCustomName != null) {
            this.setCustomName(legacyCustomName);
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        CustomScale rootScale = this.getModelPartScale(ModelPartType.ROOT);
        if (rootScale.x() != 1.0f || rootScale.y() != 1.0f) {
            EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
            return baseDimensions.scale(rootScale.x(), rootScale.y());
        }
        return super.getDefaultDimensions(pose);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EasyNPCBase)) {
            return false;
        }
        EasyNPCBase easyNPCBase = (EasyNPCBase)object;
        return Objects.equals(this.getUUID(), easyNPCBase.getEntityUUID());
    }

    public int hashCode() {
        return Objects.hash(this.getUUID());
    }

    public boolean isCustomNameVisible() {
        return VisibilityHandler.handleIsCustomNameVisible(this, super.isCustomNameVisible());
    }

    static {
        EasyNPCBase.registerEasyNPCSyncedData(entityDataAccessorMap, CatRaw.class);
    }

    public static enum VariantType {
        ALL_BLACK,
        BLACK,
        BRITISH_SHORTHAIR,
        CALICO,
        JELLIE,
        OCELOT,
        PERSIAN,
        RAGDOLL,
        RED,
        SIAMESE,
        TABBY,
        WHITE;

    }
}

