/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.validator;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UrlValidator {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String[] FORBIDDEN_EXTENSIONS = new String[]{".exe", ".msi", ".dmg", ".jar", ".bat", ".cmd", ".com", ".pif", ".scr", ".cpl", ".msc", ".jar", ".app", ".sh", ".vb", ".vbs", ".vbe", ".js", ".jse", ".ws", ".wsc", ".wsh", ".ps1", ".ps1xml", ".ps2", ".ps2xml", ".psc1", ".psc2", ".msh", ".msh1", ".msh2", ".mshxml", ".msh1xml", ".msh2xml", ".scf", ".lnk", ".inf", ".reg", ".dll", ".sys", ".drv", ".cpl", ".ocx", ".ax", ".spl", ".scr", ".mui", ".dmp", ".sys", ".cpl", ".ocx", ".ax", ".spl", ".scr", ".mui", ".dmp", ".msc", ".msp", ".msu", ".paf", ".zip", ".rar", ".7z", ".tar", ".gz", ".tgz"};

    private UrlValidator() {
    }

    public static boolean isValidUrl(String url) {
        if (url == null || url.isEmpty() || !url.startsWith("http://") && !url.startsWith("https://")) {
            if (url != null && !url.isEmpty()) {
                log.error("Invalid URL: {}", (Object)url);
            }
            return false;
        }
        for (String extension : FORBIDDEN_EXTENSIONS) {
            if (!url.endsWith(extension)) continue;
            log.error("Forbidden extension found in URL: {}", (Object)url);
            return false;
        }
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Invalid URL format: {}", (Object)url);
            return false;
        }
        return true;
    }
}

