/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public interface VariantDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_VARIANT_TYPE_TAG = "VariantType";

    public static void registerSyncedVariantData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Variant Type Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.VARIANT_TYPE, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.STRING));
    }

    default public Enum<?> getDefaultVariantType() {
        return VariantType.STEVE;
    }

    default public Enum<?> getVariantType() {
        return this.getVariantType((String)this.getSynchedEntityData(SynchedDataIndex.VARIANT_TYPE));
    }

    default public void setVariantType(Enum<?> variant) {
        this.setSynchedEntityData(SynchedDataIndex.VARIANT_TYPE, variant != null ? variant.name() : "");
        this.handleVariantTypeChange(variant);
    }

    default public void setVariantType(String name) {
        Enum<?> variantType = this.getVariantType(name);
        if (variantType != null) {
            this.setVariantType(variantType);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    default public void handleVariantTypeChange(Enum<?> variant) {
    }

    default public Enum<?> getVariantType(String name) {
        return VariantType.valueOf(name);
    }

    default public Enum<?>[] getVariantTypes() {
        return VariantType.values();
    }

    default public Stream<String> getVariantTypeNames() {
        return Stream.of(this.getVariantTypes()).map(Enum::name);
    }

    default public Component getVariantTypeName() {
        Enum<?> variant = this.getVariantType();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.getEntityTypeName();
    }

    default public boolean hasVariantTypeCrossedArms() {
        return this.hasVariantTypeCrossedArms(this.getVariantType());
    }

    default public boolean hasVariantTypeCrossedArms(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_CROSSED_ARMS");
    }

    default public boolean hasVariantTypeSaddled() {
        return this.hasVariantTypeSaddled(this.getVariantType());
    }

    default public boolean hasVariantTypeSaddled(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_SADDLED");
    }

    default public VillagerProfession getVillagerProfession(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (VillagerProfession profession : BuiltInRegistries.VILLAGER_PROFESSION) {
            if (!name.endsWith(profession.name().toLowerCase(Locale.ROOT))) continue;
            return profession;
        }
        return null;
    }

    default public VillagerType getVillagerType(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (VillagerType villagerType : BuiltInRegistries.VILLAGER_TYPE) {
            if (!name.startsWith(villagerType.toString().toLowerCase(Locale.ROOT))) continue;
            return villagerType;
        }
        return null;
    }

    default public void defineSynchedVariantData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.VARIANT_TYPE, this.getDefaultVariantType().name());
    }

    default public void addAdditionalVariantData(CompoundTag compoundTag) {
        if (this.getVariantType() != null) {
            compoundTag.putString(EASY_NPC_DATA_VARIANT_TYPE_TAG, this.getVariantType().name());
        }
    }

    default public void readAdditionalVariantData(CompoundTag compoundTag) {
        String variantType;
        if (compoundTag.contains(EASY_NPC_DATA_VARIANT_TYPE_TAG) && !(variantType = compoundTag.getString(EASY_NPC_DATA_VARIANT_TYPE_TAG)).isEmpty()) {
            this.setVariantType(this.getVariantType(variantType));
        }
    }

    public static enum VariantType {
        STEVE,
        ALEX;

    }
}

