/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item;

import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.item.EasyNPCSpawnerBlockItem;
import de.markusbordihn.easynpc.item.ModSpawnEggItem;
import de.markusbordihn.easynpc.item.attack.BulletItem;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetEmptyItem;
import de.markusbordihn.easynpc.item.configuration.EasyNPCPresetItem;
import de.markusbordihn.easynpc.item.configuration.MoveEasyNPCItem;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModItems {
    public static final DeferredRegister.Items ITEMS;
    public static final Map<ModNPCEntityType, DeferredItem<Item>> NPC_SPAWN_EGGS;
    public static final Map<ModCustomEntityType, DeferredItem<Item>> CUSTOM_NPC_SPAWN_EGGS;
    public static final DeferredItem<Item> BULLET_ITEM;
    public static final DeferredItem<Item> EASY_NPC_PRESET_EMPTY_ITEM;
    public static final DeferredItem<Item> EASY_NPC_PRESET_ITEM;
    public static final DeferredItem<Item> EASY_NPC_SPAWNER_BOSS;
    public static final DeferredItem<Item> EASY_NPC_SPAWNER_DEFAULT;
    public static final DeferredItem<Item> EASY_NPC_SPAWNER_GROUP;
    public static final DeferredItem<Item> EASY_NPC_SPAWNER_SINGLE;
    public static final DeferredItem<Item> MOVE_EASY_NPC;
    private static final Logger log;

    private ModItems() {
    }

    private static DeferredItem<Item> registerSpawnEgg(String id, Supplier<? extends EntityType<?>> entityTypeSupplier) {
        String spawnEggId = id + "_spawn_egg";
        return ITEMS.register(spawnEggId, () -> new ModSpawnEggItem(entityTypeSupplier, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)spawnEggId))).rarity(Rarity.EPIC)));
    }

    static {
        DeferredHolder<EntityType<?>, EntityType<?>> entityTypeObject;
        ITEMS = DeferredRegister.createItems((String)"easy_npc");
        NPC_SPAWN_EGGS = new EnumMap<ModNPCEntityType, DeferredItem<Item>>(ModNPCEntityType.class);
        CUSTOM_NPC_SPAWN_EGGS = new EnumMap<ModCustomEntityType, DeferredItem<Item>>(ModCustomEntityType.class);
        BULLET_ITEM = ITEMS.register("bullet", () -> new BulletItem(new Item.Properties()));
        EASY_NPC_PRESET_EMPTY_ITEM = ITEMS.register("easy_npc_preset_empty", () -> new EasyNPCPresetEmptyItem(new Item.Properties()));
        EASY_NPC_PRESET_ITEM = ITEMS.register("easy_npc_preset", () -> new EasyNPCPresetItem(new Item.Properties()));
        EASY_NPC_SPAWNER_BOSS = ITEMS.register(SpawnerType.BOSS_SPAWNER.getId(), () -> new EasyNPCSpawnerBlockItem((Block)ModBlocks.EASY_NPC_SPAWNER_BOSS.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)SpawnerType.BOSS_SPAWNER.getId()))), SpawnerType.BOSS_SPAWNER));
        EASY_NPC_SPAWNER_DEFAULT = ITEMS.register(SpawnerType.DEFAULT_SPAWNER.getId(), () -> new EasyNPCSpawnerBlockItem((Block)ModBlocks.EASY_NPC_SPAWNER_DEFAULT.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)SpawnerType.DEFAULT_SPAWNER.getId()))), SpawnerType.DEFAULT_SPAWNER));
        EASY_NPC_SPAWNER_GROUP = ITEMS.register(SpawnerType.GROUP_SPAWNER.getId(), () -> new EasyNPCSpawnerBlockItem((Block)ModBlocks.EASY_NPC_SPAWNER_GROUP.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)SpawnerType.GROUP_SPAWNER.getId()))), SpawnerType.GROUP_SPAWNER));
        EASY_NPC_SPAWNER_SINGLE = ITEMS.register(SpawnerType.SINGLE_SPAWNER.getId(), () -> new EasyNPCSpawnerBlockItem((Block)ModBlocks.EASY_NPC_SPAWNER_SINGLE.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)SpawnerType.SINGLE_SPAWNER.getId()))), SpawnerType.SINGLE_SPAWNER));
        MOVE_EASY_NPC = ITEMS.register("move_easy_npc", () -> new MoveEasyNPCItem(new Item.Properties()));
        log = LogManager.getLogger((String)"Easy NPC: Core");
        for (ModNPCEntityType modNPCEntityType : ModNPCEntityType.values()) {
            entityTypeObject = ModEntityType.NPC_TYPE.get(modNPCEntityType);
            if (entityTypeObject == null) {
                log.error("Unable to register NPC spawn egg with id {}.", (Object)modNPCEntityType.getId());
                continue;
            }
            log.info("Registering NPC spawn egg for {} with id {}.", entityTypeObject, (Object)modNPCEntityType.getId());
            NPC_SPAWN_EGGS.put(modNPCEntityType, ModItems.registerSpawnEgg(modNPCEntityType.getId(), entityTypeObject));
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            entityTypeObject = ModEntityType.CUSTOM_TYPE.get(enum_);
            if (entityTypeObject == null) {
                log.error("Unable to register custom spawn egg with id {}.", (Object)((ModCustomEntityType)enum_).getId());
                continue;
            }
            log.info("Registering custom spawn egg for {} with id {}.", entityTypeObject, (Object)((ModCustomEntityType)enum_).getId());
            CUSTOM_NPC_SPAWN_EGGS.put((ModCustomEntityType)enum_, ModItems.registerSpawnEgg(((ModCustomEntityType)enum_).getId(), entityTypeObject));
        }
    }
}

