/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemUtils {
    private static final ResourceLocation EASY_NPC_WAND_RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"easy_npc_wand");
    private static Item cachedEasyNpcWandItem = null;

    private ItemUtils() {
    }

    public static boolean isPlayerHoldingEasyNPCWand(Player player) {
        if (player == null) {
            return false;
        }
        Item easyNpcWandItem = ItemUtils.getEasyNPCWandItem();
        if (easyNpcWandItem == null || easyNpcWandItem == Items.AIR) {
            return false;
        }
        return ItemUtils.isPlayerHoldingItem(player, easyNpcWandItem);
    }

    public static boolean isPlayerHoldingItem(Player player, Item targetItem) {
        if (player == null || targetItem == null) {
            return false;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (ItemUtils.isItemStackOfType(mainHandItem, targetItem)) {
            return true;
        }
        ItemStack offHandItem = player.getOffhandItem();
        return ItemUtils.isItemStackOfType(offHandItem, targetItem);
    }

    private static boolean isItemStackOfType(ItemStack itemStack, Item targetItem) {
        return !itemStack.isEmpty() && itemStack.getItem() == targetItem;
    }

    public static Item getEasyNPCWandItem() {
        if (cachedEasyNpcWandItem == null) {
            cachedEasyNpcWandItem = (Item)BuiltInRegistries.ITEM.getValue(EASY_NPC_WAND_RESOURCE_LOCATION);
        }
        return cachedEasyNpcWandItem;
    }
}

