/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.skin;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public enum SkinType {
    CUSTOM,
    DEFAULT,
    INSECURE_REMOTE_URL,
    NONE,
    PLAYER_SKIN,
    SERVER_SKIN,
    SECURE_REMOTE_URL;

    public static final StreamCodec<RegistryFriendlyByteBuf, SkinType> STREAM_CODEC;

    public static SkinType get(String skinType) {
        if (skinType == null || skinType.isEmpty()) {
            return DEFAULT;
        }
        try {
            return SkinType.valueOf(skinType);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT;
        }
    }

    static {
        STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SkinType>(){

            public SkinType decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                return (SkinType)registryFriendlyByteBuf.readEnum(SkinType.class);
            }

            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, SkinType skinType) {
                registryFriendlyByteBuf.writeEnum((Enum)skinType);
            }
        };
    }
}

