/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;

public interface AttackDataCapable<E extends PathfinderMob>
extends EasyNPC<E>,
NeutralMob,
RangedAttackMob,
CrossbowAttackMob {
    public static void registerSyncedAttackData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Attack Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.BOOLEAN));
    }

    public int getAttackAnimationTick();

    default public boolean isChargingCrossbow() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW);
    }

    default public void setChargingCrossbow(boolean isCharging) {
        this.setSynchedEntityData(SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW, isCharging);
    }

    default public void performRangedAttack(LivingEntity livingEntity, float damage) {
        AttackHandler.performDefaultRangedAttack(this.getLivingEntity(), livingEntity, damage);
    }

    default public void defineSynchedAttackData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.ATTACK_IS_CHARGING_CROSSBOW, false);
    }

    default public void addAdditionalAttackData(CompoundTag compoundTag) {
    }

    default public void readAdditionalAttackData(CompoundTag compoundTag) {
    }
}

