/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.PigRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PigRenderState;
import net.minecraft.resources.ResourceLocation;

public class PigRawRenderer
extends PigRenderer
implements EasyNPCEntityRenderer {
    protected static final Map<PigRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(PigRaw.VariantType.class), map -> {
        map.put(PigRaw.VariantType.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/pig/pig.png"));
        map.put(PigRaw.VariantType.SPOTTED, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/pig/pig_spotted.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)PigRaw.VariantType.DEFAULT);

    public PigRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(PigRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

