/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class SpinButton<T>
extends CustomButton {
    private final TextButton previousButton;
    private final TextButton nextButton;
    private final TextButton textButton;
    private final Set<T> values = new LinkedHashSet<T>();
    private final T defaultValue;
    private final OnChange onChange;
    private T currentValue;

    public SpinButton(int x, int y, int width, int height, Set<T> values, T initialValue, OnChange onChange) {
        super(x, y, width, height);
        this.values.addAll(values);
        this.defaultValue = initialValue;
        this.currentValue = initialValue;
        this.onChange = onChange;
        int navigationButtonWidth = 10;
        this.previousButton = new TextButton(x, y, navigationButtonWidth, height, "<", this::changeToPreviousValue);
        this.textButton = new TextButton(x + navigationButtonWidth, y, width - 2 * navigationButtonWidth, height);
        this.nextButton = new TextButton(x + width - navigationButtonWidth, y, navigationButtonWidth, height, ">", this::changeToNextValue);
    }

    private void changeToPreviousValue(Button button) {
        T previousValue = null;
        for (T value : this.values) {
            if (value.equals(this.currentValue)) break;
            previousValue = value;
        }
        if (previousValue != null) {
            this.set(previousValue);
        }
    }

    private void changeToNextValue(Button button) {
        T nextValue = null;
        boolean found = false;
        for (T value : this.values) {
            if (found) {
                nextValue = value;
                break;
            }
            if (!value.equals(this.currentValue)) continue;
            found = true;
        }
        if (nextValue != null) {
            this.set(nextValue);
        }
    }

    public void set(T value) {
        this.currentValue = value;
        if (this.onChange != null) {
            this.onChange.onChange(this);
        }
    }

    public T get() {
        return this.currentValue;
    }

    @Override
    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        this.previousButton.renderButton(guiGraphics, left, top, partialTicks);
        this.nextButton.renderButton(guiGraphics, left, top, partialTicks);
        this.textButton.renderButton(guiGraphics, left, top, partialTicks);
        this.textButton.setMessage((Component)TextComponent.getText(this.currentValue.toString()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.nextButton.mouseClicked(mouseX, mouseY, button) || this.previousButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.textButton.mouseClicked(mouseX, mouseY, button);
    }

    public static interface OnChange {
        public void onChange(SpinButton<?> var1);
    }
}

