/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.objective;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectiveDataSet {
    public static final String DATA_OBJECTIVE_DATA_SET_TAG = "ObjectiveDataSet";
    public static final StreamCodec<RegistryFriendlyByteBuf, ObjectiveDataSet> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ObjectiveDataSet>(){

        public ObjectiveDataSet decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new ObjectiveDataSet(registryFriendlyByteBuf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, ObjectiveDataSet objectiveDataSet) {
            registryFriendlyByteBuf.writeNbt((Tag)objectiveDataSet.createTag());
        }
    };
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final HashMap<String, ObjectiveDataEntry> objectives = new HashMap();
    private final HashSet<String> targetedPlayerSet = new HashSet();
    private final HashSet<UUID> targetedEntitySet = new HashSet();
    private boolean hasEntityTarget = false;
    private boolean hasObjectives = false;
    private boolean hasOwnerTarget = false;
    private boolean hasPlayerTarget = false;
    private boolean hasTravelTarget = false;

    public ObjectiveDataSet() {
    }

    public ObjectiveDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public Set<ObjectiveDataEntry> getObjectives() {
        return new HashSet<ObjectiveDataEntry>(this.objectives.values());
    }

    public ObjectiveDataEntry getOrCreateObjective(ObjectiveType objectiveType) {
        return this.getOrCreateObjective(objectiveType, objectiveType.getDefaultPriority());
    }

    public ObjectiveDataEntry getOrCreateObjective(ObjectiveType objectiveType, int priority) {
        if (this.hasObjective(objectiveType)) {
            ObjectiveDataEntry objectiveDataEntry = this.getObjective(objectiveType);
            if (objectiveDataEntry.getPriority() != priority) {
                objectiveDataEntry.setPriority(priority);
            }
            return objectiveDataEntry;
        }
        return new ObjectiveDataEntry(objectiveType, priority);
    }

    public ObjectiveDataEntry getObjective(ObjectiveType objectiveType) {
        return this.getObjective(objectiveType.name());
    }

    public ObjectiveDataEntry getObjective(String objectiveId) {
        ObjectiveDataEntry objectiveDataEntry = this.objectives.get(objectiveId);
        if (objectiveDataEntry != null && objectiveDataEntry.getType() != ObjectiveType.NONE) {
            return objectiveDataEntry;
        }
        return null;
    }

    public boolean hasObjective(String objectiveId) {
        ObjectiveDataEntry objectiveDataEntry = this.objectives.get(objectiveId);
        return objectiveDataEntry != null && objectiveDataEntry.getType() != ObjectiveType.NONE;
    }

    public boolean hasObjective(ObjectiveType objectiveType) {
        return this.hasObjective(objectiveType.name());
    }

    public boolean hasObjectives() {
        return this.hasObjectives;
    }

    public boolean hasObjectives(Set<ObjectiveType> objectiveTypes) {
        for (ObjectiveType objectiveType : objectiveTypes) {
            if (!this.hasObjective(objectiveType)) continue;
            return true;
        }
        return false;
    }

    public void addObjective(ObjectiveDataEntry objectiveDataEntry) {
        if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) {
            return;
        }
        this.objectives.put(objectiveDataEntry.getId(), objectiveDataEntry);
        this.updateTargetFlags();
    }

    public boolean removeObjective(ObjectiveType objectiveType) {
        return this.removeObjective(objectiveType.name());
    }

    public boolean removeObjective(ObjectiveDataEntry objectiveDataEntry) {
        return this.removeObjective(objectiveDataEntry.getId());
    }

    public boolean removeObjective(String objectiveId) {
        boolean removed;
        boolean bl = removed = this.objectives.remove(objectiveId) != null;
        if (removed) {
            this.updateTargetFlags();
        }
        return removed;
    }

    public boolean hasTravelTarget() {
        return this.hasTravelTarget;
    }

    public boolean hasPlayerTarget() {
        return this.hasPlayerTarget;
    }

    public boolean hasEntityTarget() {
        return this.hasEntityTarget;
    }

    public boolean hasOwnerTarget() {
        return this.hasOwnerTarget;
    }

    public boolean isTargetedPlayer(String playerName) {
        return playerName != null && playerName.isEmpty() && this.targetedPlayerSet.contains(playerName);
    }

    public boolean isTargetedEntity(UUID entityUUID) {
        return entityUUID != null && this.targetedEntitySet.contains(entityUUID);
    }

    public boolean hasValidTarget(EasyNPC<?> easyNPC) {
        for (ObjectiveDataEntry objectiveDataEntry : this.objectives.values()) {
            if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE || objectiveDataEntry.hasValidTarget(easyNPC)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.objectives.clear();
        this.hasObjectives = false;
    }

    private void updateTargetFlags() {
        this.targetedPlayerSet.clear();
        this.targetedEntitySet.clear();
        boolean hasTravelObjectives = false;
        boolean hasPlayerTargetObjective = false;
        boolean hasEntityTargetObjective = false;
        boolean hasOwnerTargetObjective = false;
        for (ObjectiveDataEntry objectiveDataEntry : this.objectives.values()) {
            if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) continue;
            if (objectiveDataEntry.hasTravelObjective()) {
                hasTravelObjectives = true;
            }
            if (objectiveDataEntry.hasPlayerTarget()) {
                this.targetedPlayerSet.add(objectiveDataEntry.getTargetPlayerName());
                hasPlayerTargetObjective = true;
                continue;
            }
            if (objectiveDataEntry.hasEntityTarget()) {
                this.targetedEntitySet.add(objectiveDataEntry.getTargetEntityUUID());
                hasEntityTargetObjective = true;
                continue;
            }
            if (!objectiveDataEntry.hasOwnerTarget()) continue;
            hasOwnerTargetObjective = true;
        }
        this.hasTravelTarget = hasTravelObjectives;
        this.hasPlayerTarget = hasPlayerTargetObjective;
        this.hasEntityTarget = hasEntityTargetObjective;
        this.hasOwnerTarget = hasOwnerTargetObjective;
        this.hasObjectives = !this.objectives.isEmpty();
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_OBJECTIVE_DATA_SET_TAG)) {
            return;
        }
        this.clear();
        ListTag objectiveDataList = compoundTag.getListOrEmpty(DATA_OBJECTIVE_DATA_SET_TAG);
        for (int i = 0; i < objectiveDataList.size(); ++i) {
            CompoundTag objectiveDataTag = objectiveDataList.getCompoundOrEmpty(i);
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(objectiveDataTag);
            this.addObjective(objectiveDataEntry);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag objectiveDataList = new ListTag();
        for (ObjectiveDataEntry objectiveDataEntry : this.objectives.values()) {
            if (objectiveDataEntry == null || objectiveDataEntry.getType() == ObjectiveType.NONE) continue;
            objectiveDataList.add((Object)objectiveDataEntry.createTag());
        }
        compoundTag.put(DATA_OBJECTIVE_DATA_SET_TAG, (Tag)objectiveDataList);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "ObjectiveDataSet [ hasObjectives=" + this.hasObjectives + ", hasTravelTarget=" + this.hasTravelTarget + ", hasOwnerTarget=" + this.hasOwnerTarget + ", hasEntityTarget=" + this.hasEntityTarget + ", hasPlayerTarget=" + this.hasPlayerTarget + ", targetedEntitySet=" + String.valueOf(this.targetedEntitySet) + ", targetedPlayerSet=" + String.valueOf(this.targetedPlayerSet) + ", data=" + String.valueOf(this.objectives) + "]";
    }
}

