/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class RandomStrollAroundHomeGoal<T extends EasyNPC<?>>
extends RandomStrollGoal {
    private final NavigationDataCapable<?> navigationData;
    private final Entity entity;

    public RandomStrollAroundHomeGoal(T easyNPCEntity, double speedModifier) {
        super(easyNPCEntity.getPathfinderMob(), speedModifier, 240, false);
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
        this.entity = easyNPCEntity.getEntity();
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone() && !this.mob.isVehicle() && (!this.mob.isAggressive() || this.mob.getTarget() == null);
    }

    protected Vec3 getPosition() {
        if (this.mob.level().random.nextFloat() < 0.5f) {
            return this.getPositionTowardsAnywhere();
        }
        Vec3 targetPosition = this.getPositionTowardsHome();
        return targetPosition == null ? this.getPositionTowardsAnywhere() : targetPosition;
    }

    protected Vec3 getPositionTowardsHome() {
        BlockPos homeBlockPos = this.navigationData.getHomePosition();
        Vec3 homePosition = new Vec3((double)homeBlockPos.getX(), (double)homeBlockPos.getY(), (double)homeBlockPos.getZ());
        if (this.navigationData.isFlying()) {
            BlockPos blockPos = this.entity.blockPosition();
            int homePositionDifference = (int)(homePosition.y - (double)blockPos.getY());
            int flyingZ = 0;
            if (homePositionDifference > 2) {
                flyingZ = 4;
            } else if (homePositionDifference < -2) {
                flyingZ = -4;
            }
            int flyingX = 6;
            int flyingY = 8;
            int distanceToHome = blockPos.distManhattan((Vec3i)homeBlockPos);
            if (distanceToHome < 15) {
                flyingX = distanceToHome / 2;
                flyingY = distanceToHome / 2;
            }
            return AirRandomPos.getPosTowards((PathfinderMob)this.mob, (int)flyingX, (int)flyingY, (int)flyingZ, (Vec3)homePosition, (double)1.5707963705062866);
        }
        return LandRandomPos.getPosTowards((PathfinderMob)this.mob, (int)10, (int)7, (Vec3)homePosition);
    }

    private Vec3 getPositionTowardsAnywhere() {
        return LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
    }
}

