/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface DisplayAttributeDataCapable<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String DATA_DISPLAY_ATTRIBUTE_SET_TAG = "DisplayAttribute";
    public static final StreamCodec<RegistryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry>>(){

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            CompoundTag compoundTag = registryFriendlyByteBuf.readNbt();
            EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
            for (String key : compoundTag.keySet()) {
                DisplayAttributeType displayAttributeType = DisplayAttributeType.get(key);
                if (displayAttributeType == null) continue;
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry(compoundTag.getCompoundOrEmpty(key)));
            }
            return displayAttributeMap;
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : displayAttributeMap.entrySet()) {
                CompoundTag entryTag = new CompoundTag();
                entry.getValue().write(entryTag);
                compoundTag.put(entry.getKey().name(), (Tag)entryTag);
            }
            registryFriendlyByteBuf.writeNbt((Tag)compoundTag);
        }
    };

    public static void registerSyncedDisplayAttributeData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Display Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.DISPLAY_ATTRIBUTE));
    }

    default public EnumMap<DisplayAttributeType, DisplayAttributeEntry> getDisplayAttributeMap() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = (EnumMap<DisplayAttributeType, DisplayAttributeEntry>)this.getSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET);
        if (displayAttributeMap == null) {
            displayAttributeMap = this.createDefaultDisplayAttributeMap();
            this.setDisplayAttributeMap(displayAttributeMap);
        }
        return displayAttributeMap;
    }

    default public void setDisplayAttributeMap(EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap) {
        if (displayAttributeMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, displayAttributeMap, true);
        }
    }

    default public void clearDisplayAttributeMap() {
        this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, this.createDefaultDisplayAttributeMap());
    }

    default public void updateDisplayAttributeMap() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        if (displayAttributeMap != null) {
            this.setDisplayAttributeMap(new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(displayAttributeMap));
        }
    }

    default public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        return displayAttributeMap.containsKey((Object)displayAttributeType);
    }

    default public boolean getDisplayBooleanAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        DisplayAttributeEntry entry = displayAttributeMap.get((Object)displayAttributeType);
        return entry != null ? entry.booleanValue() : false;
    }

    default public int getDisplayIntAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        DisplayAttributeEntry entry = displayAttributeMap.get((Object)displayAttributeType);
        return entry != null ? entry.intValue() : 0;
    }

    default public String getDisplayStringAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        DisplayAttributeEntry entry = displayAttributeMap.get((Object)displayAttributeType);
        return entry != null ? entry.stringValue() : "";
    }

    default public <T extends Enum<T>> T getDisplayEnumAttribute(DisplayAttributeType displayAttributeType, Class<T> enumClass) {
        String enumValue = this.getDisplayStringAttribute(displayAttributeType);
        try {
            return Enum.valueOf(enumClass, enumValue);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to get enum value {} for class {}: {}", (Object)enumValue, enumClass, (Object)e);
            return null;
        }
    }

    default public <T> void setDisplayAttribute(DisplayAttributeType displayAttributeType, ValueType valueType, T value) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        switch (valueType) {
            case BOOLEAN: {
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry((Boolean)value));
                break;
            }
            case INTEGER: {
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry((Integer)value));
                break;
            }
            case STRING: {
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry((String)value));
                break;
            }
            default: {
                log.error("Invalid display value type {} for {}", (Object)valueType, (Object)displayAttributeType);
                return;
            }
        }
        this.updateDisplayAttributeMap();
    }

    default public void setDisplayAttribute(DisplayAttributeType displayAttributeType, Enum<?> enumValue) {
        this.setDisplayAttribute(displayAttributeType, ValueType.STRING, enumValue.toString());
    }

    default public EnumMap<DisplayAttributeType, DisplayAttributeEntry> createDefaultDisplayAttributeMap() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        map.put(DisplayAttributeType.LIGHT_LEVEL, new DisplayAttributeEntry(7));
        map.put(DisplayAttributeType.VISIBLE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_DAY, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_NIGHT, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_CREATIVE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_SPECTATOR, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_STANDARD, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_OWNER, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_TEAM, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.NAME_VISIBILITY, new DisplayAttributeEntry(NameVisibilityType.ALWAYS.toString()));
        return map;
    }

    default public void defineSynchedDisplayAttributeData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, this.createDefaultDisplayAttributeMap());
    }

    default public void readAdditionalDisplayAttributeData(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_DISPLAY_ATTRIBUTE_SET_TAG)) {
            return;
        }
        ListTag displayListTag = compoundTag.getListOrEmpty(DATA_DISPLAY_ATTRIBUTE_SET_TAG);
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        displayListTag.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                CompoundTag entryCompoundTag = (CompoundTag)entry;
                if (entryCompoundTag.contains("Type")) {
                    String typeString = entryCompoundTag.getString("Type").orElse("");
                    DisplayAttributeType displayAttributeType = DisplayAttributeType.get(typeString);
                    if (displayAttributeType != DisplayAttributeType.NONE) {
                        DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry(entryCompoundTag);
                        displayAttributeMap.put(displayAttributeType, displayAttributeEntry);
                    } else {
                        log.warn("Skip invalid display attribute type {}", (Object)typeString);
                    }
                } else {
                    log.warn("Skip display attribute entry without type information");
                }
            } else {
                log.error("Failed to load display attribute entry from {}", entry);
            }
        });
        this.setDisplayAttributeMap(displayAttributeMap);
    }

    default public void addAdditionalDisplayAttributeData(CompoundTag compoundTag) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        if (displayAttributeMap != null && !displayAttributeMap.isEmpty()) {
            ListTag displayListTag = new ListTag();
            displayAttributeMap.entrySet().stream().filter(mapEntry -> mapEntry.getKey() != DisplayAttributeType.NONE).forEach(mapEntry -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putString("Type", ((DisplayAttributeType)((Object)((Object)mapEntry.getKey()))).name());
                ((DisplayAttributeEntry)mapEntry.getValue()).write(entryTag);
                displayListTag.add((Object)entryTag);
            });
            compoundTag.put(DATA_DISPLAY_ATTRIBUTE_SET_TAG, (Tag)displayListTag);
        }
    }
}

