/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class ClientMenuManager {
    private static ScreenData screenData;
    private static AdditionalScreenData additionalScreenData;
    private static CompoundTag menuData;
    private static UUID menuId;

    private ClientMenuManager() {
    }

    public static void setMenuData(UUID menuId, CompoundTag menuData) {
        ClientMenuManager.clearMenuData();
        ClientMenuManager.menuId = menuId;
        ClientMenuManager.menuData = menuData;
        if (ScreenData.hasScreenData(menuData)) {
            screenData = ScreenData.decode(menuData);
            additionalScreenData = screenData != null ? new AdditionalScreenData(screenData.additionalData()) : null;
        }
    }

    public static CompoundTag getMenuData() {
        return menuData;
    }

    public static ScreenData getScreenData() {
        return screenData;
    }

    public static AdditionalScreenData getAdditionalScreenData() {
        return additionalScreenData;
    }

    public static boolean hasAdditionalScreenData() {
        return additionalScreenData != null;
    }

    public static UUID getMenuId() {
        return menuId;
    }

    public static void clearMenuData() {
        menuId = null;
        menuData = null;
        screenData = null;
        additionalScreenData = null;
    }
}

